/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.ctf;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.ctf.DatabaseGameCTF;
import com.ebicep.warlords.database.repositories.games.pojos.ctf.DatabaseGamePlayersCTF;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.DatabasePlayer;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.DatabaseBaseCTF;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.classses.DatabaseMageCTF;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.classses.DatabasePaladinCTF;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.classses.DatabaseRogueCTF;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.classses.DatabaseShamanCTF;
import com.ebicep.warlords.database.repositories.player.pojos.ctf.classses.DatabaseWarriorCTF;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Classes;
import com.ebicep.warlords.player.Specializations;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabasePlayerCTF
extends AbstractDatabaseStatInformation
implements DatabasePlayer {
    @Field(value="flags_captured")
    private int flagsCaptured = 0;
    @Field(value="flags_returned")
    private int flagsReturned = 0;
    @Field(value="total_blocks_travelled")
    private long totalBlocksTravelled = 0L;
    @Field(value="most_blocks_travelled")
    private long mostBlocksTravelled = 0L;
    @Field(value="total_time_in_respawn")
    private long totalTimeInRespawn = 0L;
    @Field(value="total_time_played")
    private long totalTimePlayed = 0L;
    private DatabaseMageCTF mage = new DatabaseMageCTF();
    private DatabaseWarriorCTF warrior = new DatabaseWarriorCTF();
    private DatabasePaladinCTF paladin = new DatabasePaladinCTF();
    private DatabaseShamanCTF shaman = new DatabaseShamanCTF();
    private DatabaseRogueCTF rogue = new DatabaseRogueCTF();

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        assert (databaseGame instanceof DatabaseGameCTF);
        assert (gamePlayer instanceof DatabaseGamePlayersCTF.DatabaseGamePlayerCTF);
        this.experience += add ? gamePlayer.getExperienceEarnedUniversal() : -gamePlayer.getExperienceEarnedUniversal();
        this.flagsCaptured += ((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getFlagCaptures();
        this.flagsReturned += ((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getFlagReturns();
        this.totalBlocksTravelled += (long)gamePlayer.getBlocksTravelled();
        if (this.mostBlocksTravelled < (long)gamePlayer.getBlocksTravelled()) {
            this.mostBlocksTravelled = gamePlayer.getBlocksTravelled();
        }
        this.totalTimeInRespawn += (long)((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getSecondsInRespawn();
        this.totalTimePlayed += (long)(900 - ((DatabaseGameCTF)databaseGame).getTimeLeft());
        this.getClass(Specializations.getClass(gamePlayer.getSpec())).updateStats(databaseGame, gamePlayer, add);
        this.getSpec(gamePlayer.getSpec()).updateStats(databaseGame, gamePlayer, add);
    }

    @Override
    public DatabaseBaseCTF getSpec(Specializations specializations) {
        switch (specializations) {
            case PYROMANCER: {
                return this.mage.getPyromancer();
            }
            case CRYOMANCER: {
                return this.mage.getCryomancer();
            }
            case AQUAMANCER: {
                return this.mage.getAquamancer();
            }
            case BERSERKER: {
                return this.warrior.getBerserker();
            }
            case DEFENDER: {
                return this.warrior.getDefender();
            }
            case REVENANT: {
                return this.warrior.getRevenant();
            }
            case AVENGER: {
                return this.paladin.getAvenger();
            }
            case CRUSADER: {
                return this.paladin.getCrusader();
            }
            case PROTECTOR: {
                return this.paladin.getProtector();
            }
            case THUNDERLORD: {
                return this.shaman.getThunderlord();
            }
            case SPIRITGUARD: {
                return this.shaman.getSpiritguard();
            }
            case EARTHWARDEN: {
                return this.shaman.getEarthwarden();
            }
            case ASSASSIN: {
                return this.rogue.getAssassin();
            }
            case VINDICATOR: {
                return this.rogue.getVindicator();
            }
            case APOTHECARY: {
                return this.rogue.getApothecary();
            }
        }
        return null;
    }

    @Override
    public DatabaseBaseCTF getClass(Classes classes) {
        switch (classes) {
            case MAGE: {
                return this.mage;
            }
            case WARRIOR: {
                return this.warrior;
            }
            case PALADIN: {
                return this.paladin;
            }
            case SHAMAN: {
                return this.shaman;
            }
            case ROGUE: {
                return this.rogue;
            }
        }
        return null;
    }

    public DatabaseBaseCTF[] getClasses() {
        return new DatabaseBaseCTF[]{this.mage, this.warrior, this.paladin, this.shaman, this.rogue};
    }

    public int getFlagsCaptured() {
        return this.flagsCaptured;
    }

    public void setFlagsCaptured(int flagsCaptured) {
        this.flagsCaptured = flagsCaptured;
    }

    public int getFlagsReturned() {
        return this.flagsReturned;
    }

    public void setFlagsReturned(int flagsReturned) {
        this.flagsReturned = flagsReturned;
    }

    public long getTotalBlocksTravelled() {
        return this.totalBlocksTravelled;
    }

    public void addTotalBlocksTravelled(long totalBlocksTravelled) {
        this.totalBlocksTravelled += totalBlocksTravelled;
    }

    public long getMostBlocksTravelled() {
        return this.mostBlocksTravelled;
    }

    public void setMostBlocksTravelled(long mostBlocksTravelled) {
        this.mostBlocksTravelled = mostBlocksTravelled;
    }

    public long getTotalTimeInRespawn() {
        return this.totalTimeInRespawn;
    }

    public void addTotalTimeInRespawn(long totalTimeInRespawn) {
        this.totalTimeInRespawn += totalTimeInRespawn;
    }

    public long getTotalTimePlayed() {
        return this.totalTimePlayed;
    }

    public void addTotalTimePlayed(long totalTimePlayed) {
        this.totalTimePlayed += totalTimePlayed;
    }

    public DatabaseMageCTF getMage() {
        return this.mage;
    }

    public DatabaseWarriorCTF getWarrior() {
        return this.warrior;
    }

    public DatabasePaladinCTF getPaladin() {
        return this.paladin;
    }

    public DatabaseShamanCTF getShaman() {
        return this.shaman;
    }

    public DatabaseRogueCTF getRogue() {
        return this.rogue;
    }
}

