/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos.ctf;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.ctf.DatabaseGameCTF;
import com.ebicep.warlords.database.repositories.games.pojos.ctf.DatabaseGamePlayersCTF;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.game.GameMode;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseBaseCTF
extends AbstractDatabaseStatInformation {
    @Field(value="flags_captured")
    private int flagsCaptured = 0;
    @Field(value="flags_returned")
    private int flagsReturned = 0;
    @Field(value="total_blocks_travelled")
    private long totalBlocksTravelled = 0L;
    @Field(value="most_blocks_travelled")
    private long mostBlocksTravelled = 0L;
    @Field(value="total_time_in_respawn")
    private long totalTimeInRespawn = 0L;
    @Field(value="total_time_played")
    private long totalTimePlayed = 0L;

    @Override
    public void updateCustomStats(DatabaseGameBase databaseGame, GameMode gameMode, DatabaseGamePlayerBase gamePlayer, DatabaseGamePlayerResult result, boolean isCompGame, boolean add) {
        assert (databaseGame instanceof DatabaseGameCTF);
        assert (gamePlayer instanceof DatabaseGamePlayersCTF.DatabaseGamePlayerCTF);
        this.experience += add ? gamePlayer.getExperienceEarnedSpec() : -gamePlayer.getExperienceEarnedSpec();
        this.flagsCaptured += ((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getFlagCaptures();
        this.flagsReturned += ((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getFlagReturns();
        this.totalBlocksTravelled += (long)gamePlayer.getBlocksTravelled();
        if (this.mostBlocksTravelled < (long)gamePlayer.getBlocksTravelled()) {
            this.mostBlocksTravelled = gamePlayer.getBlocksTravelled();
        }
        this.totalTimeInRespawn += (long)((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)gamePlayer).getSecondsInRespawn();
        this.totalTimePlayed += (long)(900 - ((DatabaseGameCTF)databaseGame).getTimeLeft());
    }

    public int getFlagsCaptured() {
        return this.flagsCaptured;
    }

    public void setFlagsCaptured(int flagsCaptured) {
        this.flagsCaptured = flagsCaptured;
    }

    public int getFlagsReturned() {
        return this.flagsReturned;
    }

    public void setFlagsReturned(int flagsReturned) {
        this.flagsReturned = flagsReturned;
    }

    public long getTotalBlocksTravelled() {
        return this.totalBlocksTravelled;
    }

    public void addTotalBlocksTravelled(long totalBlocksTravelled) {
        this.totalBlocksTravelled += totalBlocksTravelled;
    }

    public long getMostBlocksTravelled() {
        return this.mostBlocksTravelled;
    }

    public void setMostBlocksTravelled(long mostBlocksTravelled) {
        this.mostBlocksTravelled = mostBlocksTravelled;
    }

    public long getTotalTimeInRespawn() {
        return this.totalTimeInRespawn;
    }

    public void addTotalTimeInRespawn(long totalTimeInRespawn) {
        this.totalTimeInRespawn += totalTimeInRespawn;
    }

    public long getTotalTimePlayed() {
        return this.totalTimePlayed;
    }

    public void addTotalTimePlayed(long totalTimePlayed) {
        this.totalTimePlayed += totalTimePlayed;
    }
}

