/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player.pojos;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMode;

public abstract class AbstractDatabaseStatInformation {
    protected int kills = 0;
    protected int assists = 0;
    protected int deaths = 0;
    protected int wins = 0;
    protected int losses = 0;
    protected int plays = 0;
    protected long damage = 0L;
    protected long healing = 0L;
    protected long absorbed = 0L;
    protected long experience = 0L;

    public void updateStats(DatabaseGameBase databaseGame, DatabaseGamePlayerBase gamePlayer, boolean add) {
        DatabaseGamePlayerResult result = databaseGame.getPlayerGameResult(gamePlayer);
        int operation = add ? 1 : -1;
        this.kills += gamePlayer.getTotalKills() * operation;
        this.assists += gamePlayer.getTotalAssists() * operation;
        this.deaths += gamePlayer.getTotalDeaths() * operation;
        switch (result) {
            case WON: {
                this.wins += operation;
                break;
            }
            case LOST: 
            case DRAW: {
                this.losses += operation;
                break;
            }
        }
        this.plays += operation;
        this.damage += gamePlayer.getTotalDamage() * (long)operation;
        this.healing += gamePlayer.getTotalHealing() * (long)operation;
        this.absorbed += gamePlayer.getTotalAbsorbed() * (long)operation;
        this.updateCustomStats(databaseGame, databaseGame.getGameMode(), gamePlayer, result, databaseGame.getGameAddons().contains((Object)GameAddon.PRIVATE_GAME), add);
    }

    public abstract void updateCustomStats(DatabaseGameBase var1, GameMode var2, DatabaseGamePlayerBase var3, DatabaseGamePlayerResult var4, boolean var5, boolean var6);

    public double getKDA() {
        if (this.deaths <= 0) {
            return 0.0;
        }
        return (double)(this.kills + this.assists) / (double)this.deaths;
    }

    public double getKillsPerGame() {
        return this.plays <= 0 ? 0.0 : (double)this.kills / (double)this.plays;
    }

    public int getKills() {
        return this.kills;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public double getKillsAssistsPerGame() {
        return this.plays <= 0 ? 0.0 : (double)(this.kills + this.assists) / (double)this.plays;
    }

    public int getAssists() {
        return this.assists;
    }

    public void setAssists(int assists) {
        this.assists = assists;
    }

    public double getDeathsPerGame() {
        return this.plays <= 0 ? 0.0 : (double)this.deaths / (double)this.plays;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    public double getWL() {
        if (this.losses == 0) {
            return 0.0;
        }
        return (double)this.wins / (double)this.losses;
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public int getPlays() {
        return this.plays;
    }

    public void setPlays(int plays) {
        this.plays = plays;
    }

    public long getDHP() {
        return this.damage + this.healing + this.absorbed;
    }

    public long getDHPPerGame() {
        return this.plays <= 0 ? 0L : (this.damage + this.healing + this.absorbed) / (long)(this.wins + this.losses);
    }

    public long getDamage() {
        return this.damage;
    }

    public void setDamage(long damage) {
        this.damage = damage;
    }

    public long getHealing() {
        return this.healing;
    }

    public void setHealing(long healing) {
        this.healing = healing;
    }

    public long getAbsorbed() {
        return this.absorbed;
    }

    public void setAbsorbed(long absorbed) {
        this.absorbed = absorbed;
    }

    public long getExperience() {
        return this.experience;
    }

    public void setExperience(long experience) {
        this.experience = experience;
    }
}

