/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.player;

import com.ebicep.warlords.database.repositories.player.PlayerRepository;
import com.ebicep.warlords.database.repositories.player.PlayerService;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="playerService")
public class PlayerServiceImpl
implements PlayerService {
    @Autowired
    PlayerRepository playerRepository;

    @Override
    @Cacheable(cacheResolver="cacheResolver", key="#player.uuid", unless="#player == null")
    public void create(DatabasePlayer player) {
        DatabasePlayer p = this.playerRepository.insert(player);
        System.out.println("[PlayerService] Created: - " + p);
    }

    @Override
    @Cacheable(cacheResolver="cacheResolver", key="#player.uuid", unless="#player == null")
    public void create(DatabasePlayer player, PlayersCollections collection) {
        this.playerRepository.create(player, collection);
        System.out.println("[PlayerService] Created: - " + player + " in " + (Object)((Object)collection));
    }

    @Override
    @CachePut(cacheResolver="cacheResolver", key="#player.uuid", unless="#player == null")
    public void update(DatabasePlayer player) {
        DatabasePlayer p = this.playerRepository.save(player);
        System.out.println("[PlayerService] Updated: - " + p);
    }

    @Override
    @CachePut(cacheResolver="cacheResolver", key="#player.uuid", unless="#player == null")
    public void update(DatabasePlayer player, PlayersCollections collection) {
        this.playerRepository.save(player, collection);
        System.out.println("[PlayerService] Updated: - " + player + " in " + (Object)((Object)collection));
    }

    @Override
    public void delete(DatabasePlayer player) {
        this.playerRepository.delete(player);
        System.out.println("[PlayerService] Deleted: - " + player);
    }

    @Override
    public void delete(DatabasePlayer player, PlayersCollections collection) {
        this.playerRepository.delete(player, collection);
        System.out.println("[PlayerService] Deleted: - " + player + " in " + (Object)((Object)collection));
    }

    @Override
    public void deleteAll() {
        this.playerRepository.deleteAll();
    }

    @Override
    public void deleteAll(PlayersCollections collection) {
        this.playerRepository.deleteAll(collection);
    }

    @Override
    @Cacheable(cacheResolver="cacheResolver", key="#criteria.criteriaObject", unless="#result == null")
    public DatabasePlayer findOne(Criteria criteria, PlayersCollections collection) {
        return this.playerRepository.findOne(new Query().addCriteria(criteria), collection);
    }

    @Override
    @Cacheable(cacheResolver="cacheResolver", key="#uuid", unless="#result == null")
    public DatabasePlayer findByUUID(UUID uuid) {
        return this.playerRepository.findByUUID(uuid);
    }

    @Override
    @Cacheable(cacheResolver="cacheResolver", key="#uuid", unless="#result == null")
    public DatabasePlayer findByUUID(UUID uuid, PlayersCollections collection) {
        return this.playerRepository.findByUUID(uuid, collection);
    }

    @Override
    public List<DatabasePlayer> findAll() {
        return this.playerRepository.findAll();
    }

    @Override
    public List<DatabasePlayer> findAll(PlayersCollections collections) {
        return this.playerRepository.findAll(collections);
    }

    @Override
    public BulkOperations bulkOps() {
        return this.playerRepository.bulkOps();
    }

    @Override
    public List<DatabasePlayer> getPlayersSorted(Aggregation aggregation, PlayersCollections collections) {
        return this.playerRepository.getPlayersSorted(aggregation, collections);
    }

    @Override
    public <T> T convertDocumentToClass(Document document, Class<T> clazz) {
        return this.playerRepository.convertDocumentToClass(document, clazz);
    }
}

