/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.tdm;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.tdm.DatabaseGamePlayersTDM;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="Games_Information_TDM")
public class DatabaseGameTDM
extends DatabaseGameBase {
    @Field(value="time_left")
    protected int timeLeft;
    protected Team winner;
    @Field(value="blue_points")
    protected int bluePoints;
    @Field(value="red_points")
    protected int redPoints;
    protected DatabaseGamePlayersTDM players;

    public DatabaseGameTDM() {
    }

    public DatabaseGameTDM(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent gameWinEvent, boolean counted) {
        super(game, counted);
        this.timeLeft = WinAfterTimeoutOption.getTimeRemaining(game).orElse(-1);
        this.winner = gameWinEvent == null || gameWinEvent.isCancelled() ? null : gameWinEvent.getDeclaredWinner();
        this.bluePoints = game.getPoints(Team.BLUE);
        this.redPoints = game.getPoints(Team.RED);
        this.players = new DatabaseGamePlayersTDM(game);
    }

    public String toString() {
        return "DatabaseGameTDM{id='" + this.id + '\'' + ", exactDate=" + this.exactDate + ", date='" + this.date + '\'' + ", map=" + (Object)((Object)this.map) + ", gameMode=" + (Object)((Object)this.gameMode) + ", gameAddons=" + this.gameAddons + ", counted=" + this.counted + ", bluePoints=" + this.bluePoints + ", redPoints=" + this.redPoints + '}';
    }

    @Override
    public void updatePlayerStatsFromGame(DatabaseGameBase databaseGame, boolean add) {
        this.players.blue.forEach(gamePlayerTDM -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerTDM, add));
        this.players.red.forEach(gamePlayerTDM -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerTDM, add));
    }

    @Override
    public DatabaseGamePlayerResult getPlayerGameResult(DatabaseGamePlayerBase player) {
        assert (player instanceof DatabaseGamePlayersTDM.DatabaseGamePlayerTDM);
        if (this.bluePoints > this.redPoints) {
            return this.players.blue.contains((DatabaseGamePlayersTDM.DatabaseGamePlayerTDM)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        if (this.redPoints > this.bluePoints) {
            return this.players.red.contains((DatabaseGamePlayersTDM.DatabaseGamePlayerTDM)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        return DatabaseGamePlayerResult.DRAW;
    }

    @Override
    public void createHolograms() {
    }

    @Override
    public String getGameLabel() {
        return ChatColor.GRAY + this.date + ChatColor.DARK_GRAY + " - " + ChatColor.GREEN + (Object)((Object)this.map) + ChatColor.DARK_GRAY + " - " + ChatColor.GRAY + "(" + ChatColor.BLUE + this.bluePoints + ChatColor.GRAY + ":" + ChatColor.RED + this.redPoints + ChatColor.GRAY + ")" + ChatColor.DARK_GRAY + " - " + ChatColor.DARK_PURPLE + this.isCounted();
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public Team getWinner() {
        return this.winner;
    }

    public void setWinner(Team winner) {
        this.winner = winner;
    }

    public int getBluePoints() {
        return this.bluePoints;
    }

    public void setBluePoints(int bluePoints) {
        this.bluePoints = bluePoints;
    }

    public int getRedPoints() {
        return this.redPoints;
    }

    public void setRedPoints(int redPoints) {
        this.redPoints = redPoints;
    }

    public DatabaseGamePlayersTDM getPlayers() {
        return this.players;
    }

    public void setPlayers(DatabaseGamePlayersTDM players) {
        this.players = players;
    }
}

