/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.tdm;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseGamePlayersTDM {
    protected List<DatabaseGamePlayerTDM> blue = new ArrayList<DatabaseGamePlayerTDM>();
    protected List<DatabaseGamePlayerTDM> red = new ArrayList<DatabaseGamePlayerTDM>();

    public DatabaseGamePlayersTDM() {
    }

    public DatabaseGamePlayersTDM(@Nonnull Game game) {
        game.warlordsPlayers().forEach(warlordsPlayer -> {
            if (warlordsPlayer.getTeam() == Team.BLUE) {
                this.blue.add(new DatabaseGamePlayerTDM((WarlordsPlayer)warlordsPlayer));
            } else if (warlordsPlayer.getTeam() == Team.RED) {
                this.red.add(new DatabaseGamePlayerTDM((WarlordsPlayer)warlordsPlayer));
            }
        });
    }

    public List<DatabaseGamePlayerTDM> getBlue() {
        return this.blue;
    }

    public List<DatabaseGamePlayerTDM> getRed() {
        return this.red;
    }

    public static class DatabaseGamePlayerTDM
    extends DatabaseGamePlayerBase {
        @Field(value="seconds_in_combat")
        private int secondsInCombat;
        @Field(value="seconds_in_respawn")
        private int secondsInRespawn;

        public DatabaseGamePlayerTDM() {
        }

        public DatabaseGamePlayerTDM(WarlordsPlayer warlordsPlayer) {
            super(warlordsPlayer);
            this.secondsInCombat = warlordsPlayer.getMinuteStats().total().getTimeInCombat();
            this.secondsInRespawn = Math.round(warlordsPlayer.getMinuteStats().total().getRespawnTimeSpent());
        }

        public int getSecondsInCombat() {
            return this.secondsInCombat;
        }

        public void setSecondsInCombat(int secondsInCombat) {
            this.secondsInCombat = secondsInCombat;
        }

        public int getSecondsInRespawn() {
            return this.secondsInRespawn;
        }

        public void setSecondsInRespawn(int secondsInRespawn) {
            this.secondsInRespawn = secondsInRespawn;
        }
    }
}

