/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.interception;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseGamePlayersInterception {
    protected List<DatabaseGamePlayerInterception> blue = new ArrayList<DatabaseGamePlayerInterception>();
    protected List<DatabaseGamePlayerInterception> red = new ArrayList<DatabaseGamePlayerInterception>();

    public DatabaseGamePlayersInterception() {
    }

    public DatabaseGamePlayersInterception(@Nonnull Game game) {
        game.warlordsPlayers().forEach(warlordsPlayer -> {
            if (warlordsPlayer.getTeam() == Team.BLUE) {
                this.blue.add(new DatabaseGamePlayerInterception((WarlordsPlayer)warlordsPlayer));
            } else if (warlordsPlayer.getTeam() == Team.RED) {
                this.red.add(new DatabaseGamePlayerInterception((WarlordsPlayer)warlordsPlayer));
            }
        });
    }

    public List<DatabaseGamePlayerInterception> getBlue() {
        return this.blue;
    }

    public List<DatabaseGamePlayerInterception> getRed() {
        return this.red;
    }

    public static class DatabaseGamePlayerInterception
    extends DatabaseGamePlayerBase {
        @Field(value="seconds_in_combat")
        private int secondsInCombat;
        @Field(value="seconds_in_respawn")
        private int secondsInRespawn;
        @Field(value="points_captured")
        private int pointsCaptured;
        @Field(value="points_defended")
        private int pointsDefended;

        public DatabaseGamePlayerInterception() {
        }

        public DatabaseGamePlayerInterception(WarlordsPlayer warlordsPlayer) {
            super(warlordsPlayer);
            this.secondsInCombat = warlordsPlayer.getMinuteStats().total().getTimeInCombat();
            this.secondsInRespawn = Math.round(warlordsPlayer.getMinuteStats().total().getRespawnTimeSpent());
        }

        public int getSecondsInCombat() {
            return this.secondsInCombat;
        }

        public int getSecondsInRespawn() {
            return this.secondsInRespawn;
        }

        public int getPointsCaptured() {
            return this.pointsCaptured;
        }

        public int getPointsDefended() {
            return this.pointsDefended;
        }
    }
}

