/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.interception;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.interception.DatabaseGamePlayersInterception;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="Games_Information_Interception")
public class DatabaseGameInterception
extends DatabaseGameBase {
    @Field(value="time_left")
    protected int timeLeft;
    protected Team winner;
    @Field(value="blue_points")
    protected int bluePoints;
    @Field(value="red_points")
    protected int redPoints;
    protected DatabaseGamePlayersInterception players;

    public DatabaseGameInterception() {
    }

    public DatabaseGameInterception(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent gameWinEvent, boolean counted) {
        super(game, counted);
        this.timeLeft = WinAfterTimeoutOption.getTimeRemaining(game).orElse(-1);
        this.winner = gameWinEvent == null || gameWinEvent.isCancelled() ? null : gameWinEvent.getDeclaredWinner();
        this.bluePoints = game.getPoints(Team.BLUE);
        this.redPoints = game.getPoints(Team.RED);
        this.players = new DatabaseGamePlayersInterception(game);
    }

    @Override
    public void updatePlayerStatsFromGame(DatabaseGameBase databaseGame, boolean add) {
        this.players.blue.forEach(gamePlayerInterception -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerInterception, add));
        this.players.red.forEach(gamePlayerInterception -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerInterception, add));
    }

    @Override
    public DatabaseGamePlayerResult getPlayerGameResult(DatabaseGamePlayerBase player) {
        assert (player instanceof DatabaseGamePlayersInterception.DatabaseGamePlayerInterception);
        if (this.bluePoints > this.redPoints) {
            return this.players.blue.contains((DatabaseGamePlayersInterception.DatabaseGamePlayerInterception)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        if (this.redPoints > this.bluePoints) {
            return this.players.red.contains((DatabaseGamePlayersInterception.DatabaseGamePlayerInterception)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        return DatabaseGamePlayerResult.DRAW;
    }

    @Override
    public void createHolograms() {
    }

    @Override
    public String getGameLabel() {
        return "";
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public Team getWinner() {
        return this.winner;
    }

    public void setWinner(Team winner) {
        this.winner = winner;
    }

    public int getBluePoints() {
        return this.bluePoints;
    }

    public void setBluePoints(int bluePoints) {
        this.bluePoints = bluePoints;
    }

    public int getRedPoints() {
        return this.redPoints;
    }

    public void setRedPoints(int redPoints) {
        this.redPoints = redPoints;
    }
}

