/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.duel;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseGamePlayersDuel {
    protected List<DatabaseGamePlayerDuel> blue = new ArrayList<DatabaseGamePlayerDuel>();
    protected List<DatabaseGamePlayerDuel> red = new ArrayList<DatabaseGamePlayerDuel>();

    public DatabaseGamePlayersDuel() {
    }

    public DatabaseGamePlayersDuel(@Nonnull Game game) {
        game.warlordsPlayers().forEach(warlordsPlayer -> {
            if (warlordsPlayer.getTeam() == Team.BLUE) {
                this.blue.add(new DatabaseGamePlayerDuel((WarlordsPlayer)warlordsPlayer));
            } else if (warlordsPlayer.getTeam() == Team.RED) {
                this.red.add(new DatabaseGamePlayerDuel((WarlordsPlayer)warlordsPlayer));
            }
        });
    }

    public static class DatabaseGamePlayerDuel
    extends DatabaseGamePlayerBase {
        @Field(value="seconds_in_combat")
        private int secondsInCombat;

        public DatabaseGamePlayerDuel() {
        }

        public DatabaseGamePlayerDuel(WarlordsPlayer warlordsPlayer) {
            super(warlordsPlayer);
            this.secondsInCombat = warlordsPlayer.getMinuteStats().total().getTimeInCombat();
        }
    }
}

