/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.duel;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.duel.DatabaseGamePlayersDuel;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="Games_Information_Duel")
public class DatabaseGameDuel
extends DatabaseGameBase {
    @Field(value="time_left")
    protected int timeLeft;
    protected Team winner;
    protected DatabaseGamePlayersDuel players;

    public DatabaseGameDuel() {
    }

    public DatabaseGameDuel(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent gameWinEvent, boolean counted) {
        super(game, counted);
        this.timeLeft = WinAfterTimeoutOption.getTimeRemaining(game).orElse(-1);
        this.winner = gameWinEvent == null || gameWinEvent.isCancelled() ? null : gameWinEvent.getDeclaredWinner();
        this.players = new DatabaseGamePlayersDuel(game);
    }

    @Override
    public void updatePlayerStatsFromGame(DatabaseGameBase databaseGame, boolean add) {
        this.players.blue.forEach(gamePlayerDuel -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerDuel, add));
        this.players.red.forEach(gamePlayerDuel -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerDuel, add));
    }

    @Override
    public DatabaseGamePlayerResult getPlayerGameResult(DatabaseGamePlayerBase player) {
        assert (player instanceof DatabaseGamePlayersDuel.DatabaseGamePlayerDuel);
        if (this.winner == Team.BLUE) {
            return this.players.blue.contains((DatabaseGamePlayersDuel.DatabaseGamePlayerDuel)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        if (this.winner == Team.RED) {
            return this.players.red.contains((DatabaseGamePlayersDuel.DatabaseGamePlayerDuel)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        return DatabaseGamePlayerResult.DRAW;
    }

    @Override
    public void createHolograms() {
    }

    @Override
    public String getGameLabel() {
        return "";
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public Team getWinner() {
        return this.winner;
    }

    public DatabaseGamePlayersDuel getPlayers() {
        return this.players;
    }
}

