/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.ctf;

import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.player.PlayerStatisticsMinute;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseGamePlayersCTF {
    protected List<DatabaseGamePlayerCTF> blue = new ArrayList<DatabaseGamePlayerCTF>();
    protected List<DatabaseGamePlayerCTF> red = new ArrayList<DatabaseGamePlayerCTF>();

    public DatabaseGamePlayersCTF() {
    }

    public DatabaseGamePlayersCTF(@Nonnull Game game) {
        game.warlordsPlayers().forEach(warlordsPlayer -> {
            if (warlordsPlayer.getTeam() == Team.BLUE) {
                this.blue.add(new DatabaseGamePlayerCTF((WarlordsPlayer)warlordsPlayer));
            } else if (warlordsPlayer.getTeam() == Team.RED) {
                this.red.add(new DatabaseGamePlayerCTF((WarlordsPlayer)warlordsPlayer));
            }
        });
    }

    public DatabaseGamePlayersCTF(List<DatabaseGamePlayerCTF> blue, List<DatabaseGamePlayerCTF> red) {
        this.blue = blue;
        this.red = red;
    }

    public List<DatabaseGamePlayerCTF> getBlue() {
        return this.blue;
    }

    public List<DatabaseGamePlayerCTF> getRed() {
        return this.red;
    }

    public static class DatabaseGamePlayerCTF
    extends DatabaseGamePlayerBase {
        @Field(value="seconds_in_combat")
        private int secondsInCombat;
        @Field(value="seconds_in_respawn")
        private int secondsInRespawn;
        @Field(value="flag_captures")
        private int flagCaptures;
        @Field(value="flag_returns")
        private int flagReturns;
        @Field(value="total_damage_on_carrier")
        private long totalDamageOnCarrier;
        @Field(value="total_healing_on_carrier")
        private long totalHealingOnCarrier;
        @Field(value="damage_on_carrier")
        private List<Long> damageOnCarrier;
        @Field(value="healing_on_carrier")
        private List<Long> healingOnCarrier;

        public DatabaseGamePlayerCTF() {
        }

        public DatabaseGamePlayerCTF(WarlordsPlayer warlordsPlayer) {
            super(warlordsPlayer);
            this.secondsInCombat = warlordsPlayer.getMinuteStats().total().getTimeInCombat();
            this.secondsInRespawn = Math.round(warlordsPlayer.getMinuteStats().total().getRespawnTimeSpent());
            this.flagCaptures = warlordsPlayer.getFlagsCaptured();
            this.flagReturns = warlordsPlayer.getFlagsReturned();
            this.totalDamageOnCarrier = warlordsPlayer.getMinuteStats().total().getDamageOnCarrier();
            this.totalHealingOnCarrier = warlordsPlayer.getMinuteStats().total().getHealingOnCarrier();
            this.damageOnCarrier = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getDamageOnCarrier).collect(Collectors.toList());
            this.healingOnCarrier = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getHealingOnCarrier).collect(Collectors.toList());
        }

        public int getSecondsInCombat() {
            return this.secondsInCombat;
        }

        public void setSecondsInCombat(int secondsInCombat) {
            this.secondsInCombat = secondsInCombat;
        }

        public int getSecondsInRespawn() {
            return this.secondsInRespawn;
        }

        public void setSecondsInRespawn(int secondsInRespawn) {
            this.secondsInRespawn = secondsInRespawn;
        }

        public int getFlagCaptures() {
            return this.flagCaptures;
        }

        public void setFlagCaptures(int flagCaptures) {
            this.flagCaptures = flagCaptures;
        }

        public int getFlagReturns() {
            return this.flagReturns;
        }

        public void setFlagReturns(int flagReturns) {
            this.flagReturns = flagReturns;
        }

        public long getTotalDamageOnCarrier() {
            return this.totalDamageOnCarrier;
        }

        public void setTotalDamageOnCarrier(long totalDamageOnCarrier) {
            this.totalDamageOnCarrier = totalDamageOnCarrier;
        }

        public long getTotalHealingOnCarrier() {
            return this.totalHealingOnCarrier;
        }

        public void setTotalHealingOnCarrier(long totalHealingOnCarrier) {
            this.totalHealingOnCarrier = totalHealingOnCarrier;
        }

        public List<Long> getDamageOnCarrier() {
            return this.damageOnCarrier;
        }

        public void setDamageOnCarrier(List<Long> damageOnCarrier) {
            this.damageOnCarrier = damageOnCarrier;
        }

        public List<Long> getHealingOnCarrier() {
            return this.healingOnCarrier;
        }

        public void setHealingOnCarrier(List<Long> healingOnCarrier) {
            this.healingOnCarrier = healingOnCarrier;
        }
    }
}

