/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos.ctf;

import com.ebicep.jda.BotManager;
import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.games.pojos.ctf.DatabaseGamePlayersCTF;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.WinAfterTimeoutOption;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.java.NumberFormat;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.filoghost.holographicdisplays.api.beta.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import me.filoghost.holographicdisplays.api.beta.hologram.VisibilitySettings;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="Games_Information_CTF")
public class DatabaseGameCTF
extends DatabaseGameBase {
    @Field(value="time_left")
    protected int timeLeft;
    protected Team winner;
    @Field(value="blue_points")
    protected int bluePoints;
    @Field(value="red_points")
    protected int redPoints;
    protected DatabaseGamePlayersCTF players;
    @Field(value="stat_info")
    protected String statInfo;
    @Transient
    public static String lastWarlordsPlusString = "";

    public DatabaseGameCTF() {
    }

    public DatabaseGameCTF(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent gameWinEvent, boolean counted) {
        super(game, counted);
        this.timeLeft = WinAfterTimeoutOption.getTimeRemaining(game).orElse(-1);
        this.winner = gameWinEvent == null || gameWinEvent.isCancelled() ? null : gameWinEvent.getDeclaredWinner();
        this.bluePoints = game.getPoints(Team.BLUE);
        this.redPoints = game.getPoints(Team.RED);
        this.players = new DatabaseGamePlayersCTF(game);
        this.statInfo = DatabaseGameCTF.getWarlordsPlusEndGameStats(game);
    }

    public String toString() {
        return "DatabaseGameCTF{id='" + this.id + '\'' + ", exactDate=" + this.exactDate + ", date='" + this.date + '\'' + ", map=" + (Object)((Object)this.map) + ", gameMode=" + (Object)((Object)this.gameMode) + ", gameAddons=" + this.gameAddons + ", counted=" + this.counted + ", timeLeft=" + this.timeLeft + ", winner=" + (Object)((Object)this.winner) + ", bluePoints=" + this.bluePoints + ", redPoints=" + this.redPoints + ", players=" + this.players + ", statInfo='" + this.statInfo + '\'' + '}';
    }

    @Override
    public void updatePlayerStatsFromGame(DatabaseGameBase databaseGame, boolean add) {
        this.players.blue.forEach(gamePlayerCTF -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerCTF, add));
        this.players.red.forEach(gamePlayerCTF -> DatabaseGameBase.updatePlayerStatsFromTeam(databaseGame, gamePlayerCTF, add));
    }

    @Override
    public DatabaseGamePlayerResult getPlayerGameResult(DatabaseGamePlayerBase player) {
        assert (player instanceof DatabaseGamePlayersCTF.DatabaseGamePlayerCTF);
        if (this.bluePoints > this.redPoints) {
            return this.players.blue.contains((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        if (this.redPoints > this.bluePoints) {
            return this.players.red.contains((DatabaseGamePlayersCTF.DatabaseGamePlayerCTF)player) ? DatabaseGamePlayerResult.WON : DatabaseGamePlayerResult.LOST;
        }
        return DatabaseGamePlayerResult.DRAW;
    }

    @Override
    public void createHolograms() {
        ArrayList<Hologram> holograms = new ArrayList<Hologram>();
        Hologram lastGameStats = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.lastGameStatsLocation);
        holograms.add(lastGameStats);
        lastGameStats.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Last " + (this.isPrivate() ? "Comp" : "Pub") + " Game Stats");
        Hologram topDamage = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topDamageLocation);
        holograms.add(topDamage);
        topDamage.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top Damage");
        Hologram topHealing = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topHealingLocation);
        holograms.add(topHealing);
        topHealing.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top Healing");
        Hologram topAbsorbed = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topAbsorbedLocation);
        holograms.add(topAbsorbed);
        topAbsorbed.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top Absorbed");
        Hologram topDHPPerMinute = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topDHPPerMinuteLocation);
        holograms.add(topDHPPerMinute);
        topDHPPerMinute.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top DHP per Minute");
        Hologram topDamageOnCarrier = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topDamageOnCarrierLocation);
        holograms.add(topDamageOnCarrier);
        topDamageOnCarrier.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top Damage On Carrier");
        Hologram topHealingOnCarrier = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(DatabaseGameBase.topHealingOnCarrierLocation);
        holograms.add(topHealingOnCarrier);
        topHealingOnCarrier.getLines().appendText(ChatColor.AQUA + ChatColor.BOLD.toString() + "Top Healing On Carrier");
        int minutes = 15 - (int)Math.round((double)this.timeLeft / 60.0) == 0 ? 1 : 15 - (int)Math.round((double)this.timeLeft / 60.0);
        lastGameStats.getLines().appendText(ChatColor.GRAY + this.date);
        lastGameStats.getLines().appendText(ChatColor.GREEN + this.map.getMapName() + ChatColor.GRAY + "  -  " + ChatColor.GREEN + this.timeLeft / 60 + ":" + this.timeLeft % 60 + (this.timeLeft % 60 < 10 ? "0" : ""));
        lastGameStats.getLines().appendText(ChatColor.BLUE.toString() + this.bluePoints + ChatColor.GRAY + "  -  " + ChatColor.RED + this.redPoints);
        List<DatabaseGamePlayersCTF.DatabaseGamePlayerCTF> bluePlayers = this.players.blue;
        List<DatabaseGamePlayersCTF.DatabaseGamePlayerCTF> redPlayers = this.players.red;
        ArrayList<DatabaseGamePlayersCTF.DatabaseGamePlayerCTF> allPlayers = new ArrayList<DatabaseGamePlayersCTF.DatabaseGamePlayerCTF>();
        allPlayers.addAll(bluePlayers);
        allPlayers.addAll(redPlayers);
        ArrayList<String> players = new ArrayList<String>();
        for (String s3 : Utils.specsOrdered) {
            StringBuilder playerSpecs = new StringBuilder(ChatColor.AQUA + s3).append(": ");
            boolean[] add = new boolean[]{false};
            allPlayers.stream().filter(o -> o.getSpec().name.equalsIgnoreCase(s3)).forEach(p -> {
                playerSpecs.append(bluePlayers.contains(p) ? ChatColor.BLUE : ChatColor.RED).append(p.getName()).append(p.getKDAString()).append(ChatColor.GRAY).append(", ");
                add[0] = true;
            });
            if (!add[0]) continue;
            playerSpecs.setLength(playerSpecs.length() - 2);
            players.add(playerSpecs.toString());
        }
        players.forEach(s2 -> lastGameStats.getLines().appendText(s2));
        ArrayList topDamagePlayers = new ArrayList();
        ArrayList topHealingPlayers = new ArrayList();
        ArrayList topAbsorbedPlayers = new ArrayList();
        ArrayList topDHPPerGamePlayers = new ArrayList();
        ArrayList topDamageOnCarrierPlayers = new ArrayList();
        ArrayList topHealingOnCarrierPlayers = new ArrayList();
        HashMap<ChatColor, Long> totalDamage = new HashMap<ChatColor, Long>();
        HashMap<ChatColor, Long> totalHealing = new HashMap<ChatColor, Long>();
        HashMap<ChatColor, Long> totalAbsorbed = new HashMap<ChatColor, Long>();
        allPlayers.stream().sorted(Comparator.comparingLong(DatabaseGamePlayerBase::getTotalDamage).reversed()).forEach(databaseGamePlayer -> {
            totalDamage.put(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, totalDamage.getOrDefault(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, 0L) + databaseGamePlayer.getTotalDamage());
            topDamagePlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalDamage()));
        });
        allPlayers.stream().sorted(Comparator.comparingLong(DatabaseGamePlayerBase::getTotalHealing).reversed()).forEach(databaseGamePlayer -> {
            totalHealing.put(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, totalHealing.getOrDefault(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, 0L) + databaseGamePlayer.getTotalHealing());
            topHealingPlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalHealing()));
        });
        allPlayers.stream().sorted(Comparator.comparingLong(DatabaseGamePlayerBase::getTotalAbsorbed).reversed()).forEach(databaseGamePlayer -> {
            totalAbsorbed.put(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, totalAbsorbed.getOrDefault(bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED, 0L) + databaseGamePlayer.getTotalAbsorbed());
            topAbsorbedPlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalAbsorbed()));
        });
        allPlayers.stream().sorted((o1, o2) -> {
            Long p1DHPPerGame = o1.getTotalDHP() / (long)minutes;
            Long p2DHPPerGame = o2.getTotalDHP() / (long)minutes;
            return p2DHPPerGame.compareTo(p1DHPPerGame);
        }).forEach(databaseGamePlayer -> topDHPPerGamePlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalDHP() / (long)minutes)));
        allPlayers.stream().sorted(Comparator.comparingLong(DatabaseGamePlayersCTF.DatabaseGamePlayerCTF::getTotalDamageOnCarrier).reversed()).forEach(databaseGamePlayer -> topDamageOnCarrierPlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalDamageOnCarrier())));
        allPlayers.stream().sorted(Comparator.comparingLong(DatabaseGamePlayersCTF.DatabaseGamePlayerCTF::getTotalHealingOnCarrier).reversed()).forEach(databaseGamePlayer -> topHealingOnCarrierPlayers.add((bluePlayers.contains(databaseGamePlayer) ? ChatColor.BLUE : ChatColor.RED) + databaseGamePlayer.getName() + ": " + ChatColor.YELLOW + NumberFormat.addCommaAndRound(databaseGamePlayer.getTotalHealingOnCarrier())));
        this.appendTeamDHP(topDamage, totalDamage);
        this.appendTeamDHP(topHealing, totalHealing);
        this.appendTeamDHP(topAbsorbed, totalAbsorbed);
        topDamagePlayers.forEach(s2 -> topDamage.getLines().appendText(s2));
        topHealingPlayers.forEach(s2 -> topHealing.getLines().appendText(s2));
        topAbsorbedPlayers.forEach(s2 -> topAbsorbed.getLines().appendText(s2));
        topDHPPerGamePlayers.forEach(s2 -> topDHPPerMinute.getLines().appendText(s2));
        topDamageOnCarrierPlayers.forEach(s2 -> topDamageOnCarrier.getLines().appendText(s2));
        topHealingOnCarrierPlayers.forEach(s2 -> topHealingOnCarrier.getLines().appendText(s2));
        holograms.forEach(hologram -> hologram.getVisibilitySettings().setGlobalVisibility(VisibilitySettings.Visibility.HIDDEN));
        this.holograms = holograms;
    }

    @Override
    public String getGameLabel() {
        return ChatColor.GRAY + this.date + ChatColor.DARK_GRAY + " - " + ChatColor.GREEN + (Object)((Object)this.map) + ChatColor.DARK_GRAY + " - " + ChatColor.GRAY + "(" + ChatColor.BLUE + this.bluePoints + ChatColor.GRAY + ":" + ChatColor.RED + this.redPoints + ChatColor.GRAY + ")" + ChatColor.DARK_GRAY + " - " + ChatColor.DARK_PURPLE + this.isCounted();
    }

    private void appendTeamDHP(Hologram hologram, Map<ChatColor, Long> map) {
        map.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(chatColorLongEntry -> {
            ChatColor key = (ChatColor)chatColorLongEntry.getKey();
            Long value = (Long)chatColorLongEntry.getValue();
            hologram.getLines().appendText(key + (key == ChatColor.BLUE ? "Blue: " : "Red: ") + ChatColor.YELLOW + NumberFormat.addCommaAndRound(value.longValue()));
        });
    }

    public static String getWarlordsPlusEndGameStats(Game game) {
        int redPoints;
        StringBuilder output = new StringBuilder("Winners:");
        int bluePoints = game.getPoints(Team.BLUE);
        if (bluePoints > (redPoints = game.getPoints(Team.RED))) {
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.BLUE)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
            output.setLength(output.length() - 1);
            output.append("Losers:");
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.RED)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
        } else if (redPoints > bluePoints) {
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.RED)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
            output.setLength(output.length() - 1);
            output.append("Losers:");
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.BLUE)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
        } else {
            output.setLength(0);
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.BLUE)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
            for (WarlordsPlayer player : PlayerFilter.playingGame(game).matchingTeam(Team.RED)) {
                output.append(player.getUuid().toString().replace("-", "")).append("[").append(player.getMinuteStats().total().getKills()).append(":").append(player.getMinuteStats().total().getDeaths()).append("],");
            }
        }
        output.setLength(output.length() - 1);
        if (BotManager.numberOfMessagesSentLast30Sec > 15) {
            if (BotManager.numberOfMessagesSentLast30Sec < 20) {
                BotManager.getTextChannelCompsByName("games-backlog").ifPresent(textChannel -> textChannel.sendMessage("SOMETHING BROKEN DETECTED <@239929120035700737> <@253971614998331393>").queue());
            }
        } else if (game.getAddons().contains((Object)GameAddon.PRIVATE_GAME)) {
            BotManager.getTextChannelCompsByName("games-backlog").ifPresent(textChannel -> textChannel.sendMessage(output.toString()).queue());
        }
        lastWarlordsPlusString = output.toString();
        return output.toString();
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }

    public Team getWinner() {
        return this.winner;
    }

    public void setWinner(Team winner) {
        this.winner = winner;
    }

    public int getBluePoints() {
        return this.bluePoints;
    }

    public void setBluePoints(int bluePoints) {
        this.bluePoints = bluePoints;
    }

    public int getRedPoints() {
        return this.redPoints;
    }

    public void setRedPoints(int redPoints) {
        this.redPoints = redPoints;
    }

    public DatabaseGamePlayersCTF getPlayers() {
        return this.players;
    }

    public void setPlayers(DatabaseGamePlayersCTF players) {
        this.players = players;
    }

    public String getStatInfo() {
        return this.statInfo;
    }

    public void setStatInfo(String statInfo) {
        this.statInfo = statInfo;
    }

    public static String getLastWarlordsPlusString() {
        return lastWarlordsPlusString;
    }
}

