/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos;

import com.ebicep.warlords.player.ExperienceManager;
import com.ebicep.warlords.player.PlayerStatisticsMinute;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.springframework.data.mongodb.core.mapping.Field;

public class DatabaseGamePlayerBase {
    protected String uuid;
    protected String name;
    protected Specializations spec;
    @Field(value="blocks_travelled")
    protected int blocksTravelled;
    @Field(value="x_locations")
    protected String xLocations;
    @Field(value="z_locations")
    protected String zLocations;
    @Field(value="total_kills")
    protected int totalKills;
    @Field(value="total_assists")
    protected int totalAssists;
    @Field(value="total_deaths")
    protected int totalDeaths;
    @Field(value="total_damage")
    protected long totalDamage;
    @Field(value="total_healing")
    protected long totalHealing;
    @Field(value="total_absorbed")
    protected long totalAbsorbed;
    protected List<Integer> kills;
    protected List<Integer> assists;
    protected List<Integer> deaths;
    protected List<Long> damage;
    protected List<Long> healing;
    protected List<Long> absorbed;
    @Field(value="experience_earned_spec")
    protected long experienceEarnedSpec;
    @Field(value="experience_earned_universal")
    protected long experienceEarnedUniversal;

    public DatabaseGamePlayerBase() {
    }

    public DatabaseGamePlayerBase(WarlordsPlayer warlordsPlayer) {
        LinkedHashMap<String, Long> expSummary = ExperienceManager.getExpFromGameStats(warlordsPlayer, true);
        long experienceEarnedUniversal = expSummary.values().stream().mapToLong(Long::longValue).sum();
        long experienceEarnedSpec = ExperienceManager.getSpecExpFromSummary(expSummary);
        this.uuid = warlordsPlayer.getUuid().toString();
        this.name = warlordsPlayer.getName();
        this.spec = warlordsPlayer.getSpecClass();
        this.blocksTravelled = warlordsPlayer.getBlocksTravelledCM() / 100;
        this.xLocations = warlordsPlayer.getLocations().stream().map(Location::getX).map(String::valueOf).map(s2 -> s2.substring(0, s2.indexOf(".") + 2)).collect(Collectors.joining(",", "", ","));
        this.zLocations = warlordsPlayer.getLocations().stream().map(Location::getZ).map(String::valueOf).map(s2 -> s2.substring(0, s2.indexOf(".") + 2)).collect(Collectors.joining(",", "", ","));
        this.totalKills = warlordsPlayer.getMinuteStats().total().getKills();
        this.totalAssists = warlordsPlayer.getMinuteStats().total().getAssists();
        this.totalDeaths = warlordsPlayer.getMinuteStats().total().getDeaths();
        this.totalDamage = warlordsPlayer.getMinuteStats().total().getDamage();
        this.totalHealing = warlordsPlayer.getMinuteStats().total().getHealing();
        this.totalAbsorbed = warlordsPlayer.getMinuteStats().total().getAbsorbed();
        this.kills = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getKills).collect(Collectors.toList());
        this.assists = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getAssists).collect(Collectors.toList());
        this.deaths = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getDeaths).collect(Collectors.toList());
        this.damage = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getDamage).collect(Collectors.toList());
        this.healing = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getHealing).collect(Collectors.toList());
        this.absorbed = warlordsPlayer.getMinuteStats().stream().map(PlayerStatisticsMinute.Entry::getAbsorbed).collect(Collectors.toList());
        this.experienceEarnedSpec = experienceEarnedSpec;
        this.experienceEarnedUniversal = experienceEarnedUniversal;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Specializations getSpec() {
        return this.spec;
    }

    public int getBlocksTravelled() {
        return this.blocksTravelled;
    }

    public String getxLocations() {
        return this.xLocations;
    }

    public String getzLocations() {
        return this.zLocations;
    }

    public String getKDAString() {
        return ChatColor.DARK_GRAY + "[" + ChatColor.GREEN + this.getTotalKills() + ChatColor.GRAY + ":" + ChatColor.GOLD + this.getTotalAssists() + ChatColor.GRAY + ":" + ChatColor.RED + this.getTotalDeaths() + ChatColor.DARK_GRAY + "]";
    }

    public int getTotalKills() {
        return this.totalKills;
    }

    public int getTotalAssists() {
        return this.totalAssists;
    }

    public int getTotalDeaths() {
        return this.totalDeaths;
    }

    public long getTotalDHP() {
        return this.totalDamage + this.totalHealing + this.totalAbsorbed;
    }

    public long getTotalDamage() {
        return this.totalDamage;
    }

    public long getTotalHealing() {
        return this.totalHealing;
    }

    public long getTotalAbsorbed() {
        return this.totalAbsorbed;
    }

    public List<Integer> getKills() {
        return this.kills;
    }

    public List<Integer> getAssists() {
        return this.assists;
    }

    public List<Integer> getDeaths() {
        return this.deaths;
    }

    public List<Long> getDamage() {
        return this.damage;
    }

    public List<Long> getHealing() {
        return this.healing;
    }

    public List<Long> getAbsorbed() {
        return this.absorbed;
    }

    public long getExperienceEarnedSpec() {
        return this.experienceEarnedSpec;
    }

    public long getExperienceEarnedUniversal() {
        return this.experienceEarnedUniversal;
    }
}

