/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games.pojos;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.leaderboards.LeaderboardManager;
import com.ebicep.warlords.database.repositories.games.GamesCollections;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerBase;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGamePlayerResult;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.events.WarlordsGameTriggerWinEvent;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameMap;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.permissions.PermissionHandler;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.filoghost.holographicdisplays.api.beta.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import me.filoghost.holographicdisplays.api.beta.hologram.VisibilitySettings;
import me.filoghost.holographicdisplays.api.beta.hologram.line.TextHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Field;

public abstract class DatabaseGameBase {
    @Transient
    public static final Location lastGameStatsLocation = new Location(LeaderboardManager.world, -2532.5, 56.0, 766.5);
    @Transient
    public static final Location topDamageLocation = new Location(LeaderboardManager.world, -2540.5, 58.0, 785.5);
    @Transient
    public static final Location topHealingLocation = new Location(LeaderboardManager.world, -2546.5, 58.0, 785.5);
    @Transient
    public static final Location topAbsorbedLocation = new Location(LeaderboardManager.world, -2552.5, 58.0, 785.5);
    @Transient
    public static final Location topDHPPerMinuteLocation = new Location(LeaderboardManager.world, -2530.5, 59.5, 781.5);
    @Transient
    public static final Location topDamageOnCarrierLocation = new Location(LeaderboardManager.world, -2572.5, 58.0, 778.5);
    @Transient
    public static final Location topHealingOnCarrierLocation = new Location(LeaderboardManager.world, -2579.5, 58.0, 774.5);
    @Transient
    public static final Location gameSwitchLocation = new Location(LeaderboardManager.world, -2543.5, 53.5, 769.5);
    @Transient
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    @Transient
    public static List<DatabaseGameBase> previousGames = new ArrayList<DatabaseGameBase>();
    @Id
    protected String id;
    @Field(value="exact_date")
    protected Date exactDate = new Date();
    protected String date;
    protected GameMap map;
    @Field(value="game_mode")
    protected GameMode gameMode = GameMode.CAPTURE_THE_FLAG;
    @Field(value="game_addons")
    protected List<GameAddon> gameAddons = new ArrayList<GameAddon>();
    protected boolean counted = false;
    @Transient
    protected List<Hologram> holograms = new ArrayList<Hologram>();

    public DatabaseGameBase() {
    }

    public DatabaseGameBase(@Nonnull Game game, boolean counted) {
        this.exactDate = new Date();
        this.date = DATE_FORMAT.format(new Date());
        this.map = game.getMap();
        this.gameMode = game.getGameMode();
        this.gameAddons = Arrays.asList(game.getAddons().toArray(new GameAddon[0]));
        this.counted = counted;
    }

    public static void addGame(@Nonnull Game game, @Nullable WarlordsGameTriggerWinEvent gameWinEvent, boolean updatePlayerStats) {
        try {
            DatabaseGameBase databaseGame;
            float highestDamage = game.warlordsPlayers().max(Comparator.comparing(wp -> wp.getMinuteStats().total().getDamage())).get().getMinuteStats().total().getDamage();
            float highestHealing = game.warlordsPlayers().max(Comparator.comparing(wp -> wp.getMinuteStats().total().getHealing())).get().getMinuteStats().total().getHealing();
            if (highestDamage > 750000.0f || highestHealing > 750000.0f) {
                updatePlayerStats = false;
                System.out.println(ChatColor.GREEN + "[Warlords] NOT UPDATING PLAYER STATS - Game exceeds 750k damage / healing");
            }
            if (game.getAddons().contains((Object)GameAddon.PRIVATE_GAME)) {
                switch (game.getGameMode()) {
                    case DUEL: 
                    case DEBUG: 
                    case SIMULATION_TRIAL: {
                        updatePlayerStats = false;
                    }
                }
            }
            for (GameAddon addon : game.getAddons()) {
                if (!updatePlayerStats) break;
                switch (addon) {
                    case CUSTOM_GAME: 
                    case IMPOSTER_MODE: 
                    case COOLDOWN_MODE: 
                    case TRIPLE_HEALTH: 
                    case INTERCHANGE_MODE: {
                        System.out.println(ChatColor.GREEN + "[Warlords] NOT UPDATING PLAYER STATS - Some addon detected");
                        updatePlayerStats = false;
                    }
                }
            }
            if (updatePlayerStats) {
                System.out.println(ChatColor.GREEN + "[Warlords] UPDATING PLAYER STATS " + game.getGameId());
            }
            if ((databaseGame = game.getGameMode().createDatabaseGame.apply(game, gameWinEvent, updatePlayerStats)) == null) {
                System.out.println(ChatColor.GREEN + "[Warlords] Cannot add game to database - the collection has not been configured");
                return;
            }
            if (previousGames.size() > 0) {
                previousGames.get(0).deleteHolograms();
                previousGames.remove(0);
            }
            previousGames.add(databaseGame);
            databaseGame.createHolograms();
            if (!game.getAddons().contains((Object)GameAddon.CUSTOM_GAME)) {
                DatabaseGameBase.addGameToDatabase(databaseGame);
            }
            Bukkit.getOnlinePlayers().forEach(DatabaseGameBase::setGameHologramVisibility);
            for (WarlordsPlayer value : PlayerFilter.playingGame(game)) {
                if (updatePlayerStats) {
                    PermissionHandler.sendMessageToDebug(value, ChatColor.GREEN + "This game was added to the database and player information was updated");
                    continue;
                }
                PermissionHandler.sendMessageToDebug(value, ChatColor.GREEN + "This game was added to the database but player information remained the same");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR TRYING TO ADD GAME");
        }
    }

    public static void addGameToDatabase(DatabaseGameBase databaseGame) {
        if (DatabaseManager.gameService == null) {
            return;
        }
        GamesCollections collection = databaseGame.getGameMode().gamesCollections;
        databaseGame.gameAddons.remove((Object)GameAddon.CUSTOM_GAME);
        if (DatabaseManager.gameService.exists(databaseGame, collection)) {
            if (!databaseGame.isCounted()) {
                databaseGame.updatePlayerStatsFromGame(databaseGame, true);
                databaseGame.setCounted(true);
                DatabaseManager.updateGameAsync(databaseGame, collection);
                DatabaseManager.updateGameAsync(databaseGame, GamesCollections.ALL);
            }
        } else {
            if (databaseGame.isCounted()) {
                databaseGame.updatePlayerStatsFromGame(databaseGame, true);
            }
            Warlords.newChain().delay(4, TimeUnit.SECONDS).async(() -> DatabaseManager.gameService.create(databaseGame, collection)).async(() -> LeaderboardManager.addHologramLeaderboards(UUID.randomUUID().toString(), false)).execute();
        }
    }

    public static void removeGameFromDatabase(DatabaseGameBase databaseGame) {
        if (DatabaseManager.gameService == null) {
            return;
        }
        GamesCollections collection = databaseGame.getGameMode().gamesCollections;
        if (DatabaseManager.gameService.exists(databaseGame, collection) && databaseGame.isCounted()) {
            databaseGame.updatePlayerStatsFromGame(databaseGame, false);
            databaseGame.setCounted(false);
            DatabaseManager.updateGameAsync(databaseGame, collection);
            DatabaseManager.updateGameAsync(databaseGame, GamesCollections.ALL);
        }
    }

    protected static void updatePlayerStatsFromTeam(DatabaseGameBase databaseGame, DatabaseGamePlayerBase gamePlayer, boolean add) {
        if (DatabaseManager.playerService == null) {
            System.out.println("playerService is null - cannot update player stats");
            return;
        }
        DatabasePlayer databasePlayerAllTime = DatabaseManager.playerService.findByUUID(UUID.fromString(gamePlayer.getUuid()));
        DatabasePlayer databasePlayerSeason = DatabaseManager.playerService.findByUUID(UUID.fromString(gamePlayer.getUuid()), PlayersCollections.SEASON_6);
        DatabasePlayer databasePlayerWeekly = DatabaseManager.playerService.findByUUID(UUID.fromString(gamePlayer.getUuid()), PlayersCollections.WEEKLY);
        DatabasePlayer databasePlayerDaily = DatabaseManager.playerService.findByUUID(UUID.fromString(gamePlayer.getUuid()), PlayersCollections.DAILY);
        if (databasePlayerAllTime != null) {
            databasePlayerAllTime.updateStats(databaseGame, gamePlayer, add);
            DatabaseManager.updatePlayerAsync(databasePlayerAllTime);
        } else {
            System.out.println("WARNING - " + gamePlayer.getName() + " was not found in ALL_TIME");
        }
        if (databasePlayerSeason != null) {
            databasePlayerSeason.updateStats(databaseGame, gamePlayer, add);
            DatabaseManager.updatePlayerAsync(databasePlayerSeason, PlayersCollections.SEASON_6);
        } else {
            System.out.println("WARNING - " + gamePlayer.getName() + " was not found in SEASON");
        }
        if (databasePlayerWeekly != null) {
            databasePlayerWeekly.updateStats(databaseGame, gamePlayer, add);
            DatabaseManager.updatePlayerAsync(databasePlayerWeekly, PlayersCollections.WEEKLY);
        } else {
            System.out.println("WARNING - " + gamePlayer.getName() + " was not found in WEEKLY");
        }
        if (databasePlayerDaily != null) {
            databasePlayerDaily.updateStats(databaseGame, gamePlayer, add);
            DatabaseManager.updatePlayerAsync(databasePlayerDaily, PlayersCollections.DAILY);
        } else {
            System.out.println("WARNING - " + gamePlayer.getName() + " was not found in DAILY");
        }
    }

    private static int getGameBefore(int currentGame) {
        if (currentGame <= 0) {
            return previousGames.size() - 1;
        }
        return currentGame - 1;
    }

    private static int getGameAfter(int currentGame) {
        if (currentGame >= previousGames.size() - 1) {
            return 0;
        }
        return currentGame + 1;
    }

    public static void setGameHologramVisibility(Player player) {
        if (!LeaderboardManager.playerGameHolograms.containsKey(player.getUniqueId()) || LeaderboardManager.playerGameHolograms.get(player.getUniqueId()) == null || LeaderboardManager.playerGameHolograms.get(player.getUniqueId()) < 0) {
            LeaderboardManager.playerGameHolograms.put(player.getUniqueId(), previousGames.size() - 1);
        }
        int selectedGame = LeaderboardManager.playerGameHolograms.get(player.getUniqueId());
        for (int i = 0; i < previousGames.size(); ++i) {
            List<Hologram> gameHolograms = previousGames.get(i).getHolograms();
            if (i == selectedGame) {
                gameHolograms.forEach(hologram -> hologram.getVisibilitySettings().setIndividualVisibility(player, VisibilitySettings.Visibility.VISIBLE));
                continue;
            }
            gameHolograms.forEach(hologram -> hologram.getVisibilitySettings().setIndividualVisibility(player, VisibilitySettings.Visibility.HIDDEN));
        }
        DatabaseGameBase.createGameSwitcherHologram(player);
    }

    private static void createGameSwitcherHologram(Player player) {
        HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).getHolograms().stream().filter(h2 -> h2.getVisibilitySettings().isVisibleTo(player) && h2.getPosition().toLocation().equals((Object)gameSwitchLocation)).forEach(Hologram::delete);
        Hologram gameSwitcher = HolographicDisplaysAPI.get((Plugin)Warlords.getInstance()).createHologram(gameSwitchLocation);
        gameSwitcher.getLines().appendText(ChatColor.AQUA.toString() + ChatColor.UNDERLINE + "Last " + previousGames.size() + " Games");
        gameSwitcher.getLines().appendText("");
        int selectedGame = LeaderboardManager.playerGameHolograms.get(player.getUniqueId());
        int gameBefore = DatabaseGameBase.getGameBefore(selectedGame);
        int gameAfter = DatabaseGameBase.getGameAfter(selectedGame);
        if (previousGames.isEmpty()) {
            return;
        }
        TextHologramLine beforeLine = gameBefore == previousGames.size() - 1 ? gameSwitcher.getLines().appendText(ChatColor.GRAY + "Latest Game") : gameSwitcher.getLines().appendText(ChatColor.GRAY.toString() + (gameBefore + 1) + ". " + previousGames.get(gameBefore).getDate());
        if (selectedGame == previousGames.size() - 1) {
            gameSwitcher.getLines().appendText(ChatColor.GREEN + "Latest Game");
        } else {
            gameSwitcher.getLines().appendText(ChatColor.GREEN.toString() + (selectedGame + 1) + ". " + previousGames.get(selectedGame).getDate());
        }
        TextHologramLine afterLine = gameAfter == previousGames.size() - 1 ? gameSwitcher.getLines().appendText(ChatColor.GRAY + "Latest Game") : gameSwitcher.getLines().appendText(ChatColor.GRAY.toString() + (gameAfter + 1) + ". " + previousGames.get(gameAfter).getDate());
        beforeLine.setClickListener(clicker -> {
            LeaderboardManager.playerGameHolograms.put(player.getUniqueId(), gameBefore);
            DatabaseGameBase.setGameHologramVisibility(player);
        });
        afterLine.setClickListener(clicker -> {
            LeaderboardManager.playerGameHolograms.put(player.getUniqueId(), gameAfter);
            DatabaseGameBase.setGameHologramVisibility(player);
        });
        gameSwitcher.getVisibilitySettings().setGlobalVisibility(VisibilitySettings.Visibility.HIDDEN);
        gameSwitcher.getVisibilitySettings().setIndividualVisibility(player, VisibilitySettings.Visibility.VISIBLE);
    }

    public static List<DatabaseGameBase> getPreviousGames() {
        return previousGames;
    }

    public static Date convertToDateFrom(String objectId) {
        return new Date(DatabaseGameBase.convertToTimestampFrom(objectId));
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }

    public abstract void updatePlayerStatsFromGame(DatabaseGameBase var1, boolean var2);

    public abstract DatabaseGamePlayerResult getPlayerGameResult(DatabaseGamePlayerBase var1);

    public abstract void createHolograms();

    public abstract String getGameLabel();

    public boolean isPrivate() {
        return this.gameAddons.contains((Object)GameAddon.PRIVATE_GAME);
    }

    public List<Hologram> getHolograms() {
        if (this.holograms.isEmpty()) {
            this.createHolograms();
        }
        return this.holograms;
    }

    public void deleteHolograms() {
        this.holograms.forEach(Hologram::delete);
    }

    public String getId() {
        return this.id;
    }

    public Date getExactDate() {
        return this.exactDate;
    }

    public void setExactDate(Date exactDate) {
        this.exactDate = exactDate;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public GameMap getMap() {
        return this.map;
    }

    public void setMap(GameMap map) {
        this.map = map;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    public List<GameAddon> getGameAddons() {
        return this.gameAddons;
    }

    public void setGameAddons(List<GameAddon> gameAddons) {
        this.gameAddons = gameAddons;
    }

    public boolean isCounted() {
        return this.counted;
    }

    public void setCounted(boolean counted) {
        this.counted = counted;
    }
}

