/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.repositories.games;

import com.ebicep.warlords.database.repositories.games.GameService;
import com.ebicep.warlords.database.repositories.games.GamesCollections;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import java.util.List;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="gameService")
public class GameServiceImpl
implements GameService {
    @Autowired
    MongoTemplate mongoTemplate;

    @Override
    public boolean exists(DatabaseGameBase game, GamesCollections collections) {
        return this.mongoTemplate.exists(new Query().addCriteria(Criteria.where("exact_date").is(game.getExactDate())), collections.collectionName);
    }

    @Override
    public void create(DatabaseGameBase game) {
        switch (game.getGameMode()) {
            case CAPTURE_THE_FLAG: {
                this.create(game, GamesCollections.CTF);
                break;
            }
            case TEAM_DEATHMATCH: {
                this.create(game, GamesCollections.TDM);
            }
        }
    }

    @Override
    public void create(DatabaseGameBase game, GamesCollections collection) {
        this.mongoTemplate.insert(game, collection.collectionName);
        System.out.println("[GameService] " + game.getDate() + " - was created in " + collection.collectionName);
        this.mongoTemplate.insert(game, GamesCollections.ALL.collectionName);
        System.out.println("[GameService] " + game.getDate() + " - was created in " + GamesCollections.ALL.collectionName);
    }

    @Override
    public void save(DatabaseGameBase game, GamesCollections collection) {
        this.mongoTemplate.save(game, collection.collectionName);
        System.out.println("[GameService] Updated " + game.getDate() + " in " + collection.collectionName);
    }

    @Override
    public void delete(DatabaseGameBase game, GamesCollections collection) {
        this.mongoTemplate.remove(game, collection.collectionName);
        System.out.println("[GameService] Deleted " + game.getDate() + " in " + collection.collectionName);
    }

    @Override
    public DatabaseGameBase findOne(Query query, GamesCollections collection) {
        return this.mongoTemplate.findOne(query, DatabaseGameBase.class, collection.collectionName);
    }

    @Override
    public List<DatabaseGameBase> findAll(GamesCollections collection) {
        return this.mongoTemplate.findAll(DatabaseGameBase.class, collection.collectionName);
    }

    @Override
    public BulkOperations bulkOps() {
        return this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, DatabaseGameBase.class);
    }

    @Override
    public <T> T convertDocumentToClass(Document document, Class<T> clazz) {
        return this.mongoTemplate.getConverter().read(clazz, document);
    }

    @Override
    public List<? extends DatabaseGameBase> getLastGames(int amount) {
        List<DatabaseGameBase> games = this.findAll(GamesCollections.ALL);
        if (games.size() <= amount) {
            return games;
        }
        return games.subList(games.size() - amount, games.size());
    }
}

