/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.leaderboards.sections;

import com.ebicep.warlords.database.leaderboards.Leaderboard;
import com.ebicep.warlords.database.leaderboards.sections.LeaderboardCategory;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.util.java.NumberFormat;
import java.util.List;
import me.filoghost.holographicdisplays.api.beta.hologram.Hologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public abstract class LeaderboardGameType<T extends AbstractDatabaseStatInformation> {
    public static World world = Bukkit.getWorld((String)"MainLobby");
    protected final LeaderboardCategory<T> general;
    protected final LeaderboardCategory<T> comps;
    protected final LeaderboardCategory<T> pubs;

    public LeaderboardGameType(LeaderboardCategory<T> general, LeaderboardCategory<T> comps, LeaderboardCategory<T> pubs) {
        this.general = general;
        this.comps = comps;
        this.pubs = pubs;
    }

    public void addBaseLeaderboards(LeaderboardCategory<T> leaderboardCategory) {
        leaderboardCategory.getAllHolograms().forEach(Hologram::delete);
        List<Leaderboard> leaderboards = leaderboardCategory.getLeaderboards();
        leaderboards.clear();
        leaderboards.add(new Leaderboard("Wins", new Location(world, -2558.5, 56.0, 712.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getWins(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getWins())));
        leaderboards.add(new Leaderboard("Losses", new Location(world, -2608.5, 52.0, 728.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getLosses(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getLosses())));
        leaderboards.add(new Leaderboard("Plays", new Location(world, -2564.5, 56.0, 712.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getPlays(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getPlays())));
        leaderboards.add(new Leaderboard("Kills", new Location(world, -2552.5, 56.0, 712.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKills(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKills())));
        leaderboards.add(new Leaderboard("Assists", new Location(world, -2616.5, 52.0, 733.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getAssists(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getAssists())));
        leaderboards.add(new Leaderboard("Deaths", new Location(world, -2616.5, 52.0, 723.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDeaths(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDeaths())));
        leaderboards.add(new Leaderboard("Damage", new Location(world, -2600.5, 52.0, 723.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDamage(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDamage())));
        leaderboards.add(new Leaderboard("Healing", new Location(world, -2608.5, 52.0, 719.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getHealing(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getHealing())));
        leaderboards.add(new Leaderboard("Absorbed", new Location(world, -2600.5, 52.0, 733.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getAbsorbed(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getAbsorbed())));
        leaderboards.add(new Leaderboard("DHP", new Location(world, -2619.5, 66.5, 721.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDHP(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDHP())));
        leaderboards.add(new Leaderboard("DHP Per Game", new Location(world, -2546.5, 56.0, 712.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDHPPerGame(), databasePlayer -> NumberFormat.addCommaAndRound((double)Math.round((double)((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDHPPerGame() * 10.0) / 10.0)));
        leaderboards.add(new Leaderboard("Kills Per Game", new Location(world, -2619.5, 66.5, 735.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKillsPerGame(), databasePlayer -> String.valueOf((double)Math.round(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKillsPerGame() * 10.0) / 10.0)));
        leaderboards.add(new Leaderboard("Deaths Per Game", new Location(world, -2608.5, 67.0, 738.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDeathsPerGame(), databasePlayer -> String.valueOf((double)Math.round(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getDeathsPerGame() * 10.0) / 10.0)));
        leaderboards.add(new Leaderboard("Kills/Assists Per Game", new Location(world, -2608.5, 67.0, 719.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKillsAssistsPerGame(), databasePlayer -> String.valueOf((double)Math.round(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getKillsAssistsPerGame() * 10.0) / 10.0)));
        leaderboards.add(new Leaderboard("Experience", new Location(world, -2526.5, 57.0, 744.5), databasePlayer -> ((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getExperience(), databasePlayer -> NumberFormat.addCommaAndRound(((AbstractDatabaseStatInformation)leaderboardCategory.statFunction.apply((DatabasePlayer)databasePlayer)).getExperience())));
        this.addExtraLeaderboards(leaderboardCategory);
    }

    public abstract void addExtraLeaderboards(LeaderboardCategory<T> var1);

    public LeaderboardCategory<T> getGeneral() {
        return this.general;
    }

    public LeaderboardCategory<T> getComps() {
        return this.comps;
    }

    public LeaderboardCategory<T> getPubs() {
        return this.pubs;
    }
}

