/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.leaderboards;

import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Location;

public class Leaderboard {
    private final String title;
    private final Location location;
    private final List<DatabasePlayer> sortedAllTime = new ArrayList<DatabasePlayer>();
    private final List<DatabasePlayer> sortedSeason6 = new ArrayList<DatabasePlayer>();
    private final List<DatabasePlayer> sortedSeason5 = new ArrayList<DatabasePlayer>();
    private final List<DatabasePlayer> sortedSeason4 = new ArrayList<DatabasePlayer>();
    private final List<DatabasePlayer> sortedWeekly = new ArrayList<DatabasePlayer>();
    private final List<DatabasePlayer> sortedDaily = new ArrayList<DatabasePlayer>();
    private final Function<DatabasePlayer, Number> valueFunction;
    private final Function<DatabasePlayer, String> stringFunction;

    public Leaderboard(String title, Location location, Function<DatabasePlayer, Number> valueFunction, Function<DatabasePlayer, String> stringFunction) {
        this.title = title;
        this.location = location;
        this.valueFunction = valueFunction;
        this.stringFunction = stringFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Leaderboard that = (Leaderboard)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.location);
    }

    public List<DatabasePlayer> getSortedPlayers(PlayersCollections collections) {
        switch (collections) {
            case LIFETIME: {
                return this.sortedAllTime;
            }
            case SEASON_6: {
                return this.sortedSeason6;
            }
            case SEASON_5: {
                return this.sortedSeason5;
            }
            case SEASON_4: {
                return this.sortedSeason4;
            }
            case WEEKLY: {
                return this.sortedWeekly;
            }
            case DAILY: {
                return this.sortedDaily;
            }
        }
        return new ArrayList<DatabasePlayer>();
    }

    public void resetSortedPlayers(List<DatabasePlayer> newSortedPlayers, PlayersCollections collections) {
        switch (collections) {
            case LIFETIME: {
                this.sortedAllTime.clear();
                this.sortedAllTime.addAll(newSortedPlayers);
                return;
            }
            case SEASON_6: {
                this.sortedSeason6.clear();
                this.sortedSeason6.addAll(newSortedPlayers);
                return;
            }
            case SEASON_5: {
                this.sortedSeason5.clear();
                this.sortedSeason5.addAll(newSortedPlayers);
                return;
            }
            case SEASON_4: {
                this.sortedSeason4.clear();
                this.sortedSeason4.addAll(newSortedPlayers);
                return;
            }
            case WEEKLY: {
                this.sortedWeekly.clear();
                this.sortedWeekly.addAll(newSortedPlayers);
                return;
            }
            case DAILY: {
                this.sortedDaily.clear();
                this.sortedDaily.addAll(newSortedPlayers);
                return;
            }
        }
    }

    public <T extends Number> T[] getTopThreeValues() {
        Number topValue = this.valueFunction.apply(this.sortedWeekly.get(0));
        Class<?> clazz = topValue.getClass();
        Number[] output = (Number[])Array.newInstance(clazz, 3);
        output[0] = topValue;
        ArrayList<Number> topThree = new ArrayList<Number>();
        int counter = 0;
        boolean filter = this.sortedWeekly.get(0).getPlays() >= 10;
        List<DatabasePlayer> databasePlayers = filter ? this.sortedWeekly.stream().filter(databasePlayer -> databasePlayer.getPlays() > 3).collect(Collectors.toList()) : this.sortedWeekly;
        for (DatabasePlayer databasePlayer2 : databasePlayers) {
            if (databasePlayer2.getPlays() <= 3) continue;
            Number currentTopValue = this.valueFunction.apply(databasePlayer2);
            if (counter >= 2) break;
            if (Leaderboard.compare(topValue, currentTopValue) <= 0) continue;
            topThree.add(currentTopValue);
            topValue = currentTopValue;
            ++counter;
        }
        for (int i = 0; i < topThree.size(); ++i) {
            output[i + 1] = (Number)topThree.get(i);
        }
        return output;
    }

    public String[] getTopThreePlayerNames(Number[] numbers, Function<DatabasePlayer, String> function) {
        int i;
        Object[] topThreePlayers = new String[3];
        Arrays.fill(topThreePlayers, "");
        for (i = 0; i < numbers.length; ++i) {
            Number topValue = numbers[i];
            for (DatabasePlayer databasePlayer : this.sortedWeekly) {
                if (!Objects.equals(this.valueFunction.apply(databasePlayer), topValue)) continue;
                topThreePlayers[i] = (String)topThreePlayers[i] + function.apply(databasePlayer) + ",";
            }
            if (i == 2) break;
        }
        for (i = 0; i < topThreePlayers.length; ++i) {
            topThreePlayers[i] = ((String)topThreePlayers[i]).substring(0, ((String)topThreePlayers[i]).length() - 1);
        }
        return topThreePlayers;
    }

    public static int compare(Number a, Number b) {
        return new BigDecimal(a.toString()).compareTo(new BigDecimal(b.toString()));
    }

    public String getTitle() {
        return this.title;
    }

    public Location getLocation() {
        return this.location;
    }

    public List<DatabasePlayer> getSortedAllTime() {
        return this.sortedAllTime;
    }

    public List<DatabasePlayer> getSortedSeason6() {
        return this.sortedSeason6;
    }

    public List<DatabasePlayer> getSortedSeason5() {
        return this.sortedSeason5;
    }

    public List<DatabasePlayer> getSortedSeason4() {
        return this.sortedSeason4;
    }

    public List<DatabasePlayer> getSortedWeekly() {
        return this.sortedWeekly;
    }

    public List<DatabasePlayer> getSortedDaily() {
        return this.sortedDaily;
    }

    public Function<DatabasePlayer, Number> getValueFunction() {
        return this.valueFunction;
    }

    public Function<DatabasePlayer, String> getStringFunction() {
        return this.stringFunction;
    }
}

