/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.configuration;

import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.FutureMessageManager;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import javax.annotation.Nonnull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoClientConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@ComponentScan(basePackages={"com.ebicep.warlords.database"})
@EnableMongoRepositories(value={"com.ebicep.warlords.database.repositories"})
public class ApplicationConfiguration
extends AbstractMongoClientConfiguration {
    public static String key;

    @Override
    @Nonnull
    @Bean
    public MongoClient mongoClient() {
        MongoClient mongoClient;
        System.out.println("Getting mongoClient");
        DatabaseManager.mongoClient = mongoClient = MongoClients.create(key);
        DatabaseManager.warlordsDatabase = mongoClient.getDatabase("Warlords");
        DatabaseManager.gamesInformation = DatabaseManager.warlordsDatabase.getCollection("Warlords_Information");
        FutureMessageManager.futureMessages = DatabaseManager.warlordsDatabase.getCollection("Future_Messages");
        return mongoClient;
    }

    @Bean
    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongoClient(), this.getDatabaseName());
    }

    @Override
    @Nonnull
    protected String getDatabaseName() {
        return "Warlords";
    }

    @Override
    public boolean autoIndexCreation() {
        return true;
    }
}

