/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.cache;

import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheResolver;

public class MultipleCacheResolver
implements CacheResolver {
    public static CacheManager playersCacheManager;
    public static CacheManager leaderboardsCacheManager;

    public MultipleCacheResolver(CacheManager playersCacheManager, CacheManager leaderboardsCacheManager) {
        MultipleCacheResolver.playersCacheManager = playersCacheManager;
        MultipleCacheResolver.leaderboardsCacheManager = leaderboardsCacheManager;
    }

    @Override
    @Nonnull
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        List<Object> list = Arrays.asList(context.getArgs());
        for (PlayersCollections value : PlayersCollections.values()) {
            if (!list.contains((Object)value)) continue;
            caches.add(playersCacheManager.getCache(value.cacheName));
            break;
        }
        if (caches.isEmpty()) {
            caches.add(playersCacheManager.getCache(PlayersCollections.LIFETIME.cacheName));
        }
        return caches;
    }
}

