/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database.cache;

import com.ebicep.warlords.database.cache.MultipleCacheResolver;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class MultipleCacheManagerConfig
extends CachingConfigurerSupport {
    @Override
    @Bean
    @Primary
    public CacheManager cacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        cacheManager.setCacheNames(Arrays.stream(PlayersCollections.values()).map(collections -> collections.cacheName).collect(Collectors.toList()));
        cacheManager.setCaffeine(Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES));
        return cacheManager;
    }

    @Bean
    public CacheManager alternateCacheManager() {
        return new ConcurrentMapCacheManager("leaderboards");
    }

    @Override
    @Bean
    public CacheResolver cacheResolver() {
        return new MultipleCacheResolver(this.cacheManager(), this.alternateCacheManager());
    }
}

