/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.database;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class FutureMessageManager
implements Listener {
    public static MongoCollection<Document> futureMessages;

    public static void addNewFutureMessageDocument(UUID uuid, boolean centered, String ... messages) {
        if (futureMessages == null) {
            return;
        }
        Document previousDocument = FutureMessageManager.getPlayerDocument(uuid);
        if (previousDocument != null) {
            futureMessages.updateOne(Filters.eq("uuid", uuid.toString()), Updates.pushEach("messages", Arrays.stream(messages).collect(Collectors.toList())));
        } else {
            futureMessages.insertOne(new Document("uuid", uuid.toString()).append("centered", centered).append("messages", Arrays.stream(messages).collect(Collectors.toList())));
        }
    }

    public static void addNewFutureMessageDocuments(List<Document> documents) {
        if (futureMessages == null) {
            return;
        }
        futureMessages.insertMany(documents);
    }

    public static void editFutureMessage(UUID uuid, boolean centered, String ... newMessages) {
        if (futureMessages == null) {
            return;
        }
        if (FutureMessageManager.getPlayerDocument(uuid) != null) {
            futureMessages.updateOne(Filters.eq("uuid", uuid.toString()), new Document("$set", new Document("centered", centered).append("messages", Arrays.stream(newMessages).collect(Collectors.toList()))));
        }
    }

    public static Document getPlayerDocument(UUID uuid) {
        return (Document)futureMessages.find().filter(Filters.eq("uuid", uuid.toString())).first();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (futureMessages == null) {
            return;
        }
        Player player = e.getPlayer();
        Document playerDocument = FutureMessageManager.getPlayerDocument(player.getUniqueId());
        if (playerDocument != null) {
            boolean centered = playerDocument.getBoolean("centered");
            Warlords.newChain().delay(20).sync(() -> {
                List<String> messages = playerDocument.getList("messages", String.class);
                messages.forEach(m4 -> {
                    if (centered) {
                        ChatUtils.sendCenteredMessage(player, m4);
                    } else {
                        player.sendMessage(m4);
                    }
                });
            }).async(() -> futureMessages.deleteOne(Filters.eq("uuid", player.getUniqueId().toString()))).execute();
        }
    }
}

