/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.miscellaneouscommands;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.BaseCommand;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.menu.Menu;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpectateCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        Player player = BaseCommand.requirePlayerOutsideGame(sender);
        if (player != null) {
            if (!Warlords.getGameManager().getGames().stream().anyMatch(e -> e.getGame() != null && e.getGame().acceptsSpectators())) {
                sender.sendMessage(ChatColor.RED + "There are no active games right now!");
                return true;
            }
            Optional<Game> currentGame = Warlords.getGameManager().getPlayerGame(player.getUniqueId());
            if (currentGame.isPresent() && currentGame.get().getPlayerTeam(player.getUniqueId()) != null) {
                sender.sendMessage(ChatColor.RED + "You cannot use this command inside a game!");
                return true;
            }
            SpectateCommand.openSpectateMenu(player);
            return true;
        }
        return true;
    }

    public void register(Warlords instance) {
        instance.getCommand("spectate").setExecutor((CommandExecutor)this);
    }

    public static void openSpectateMenu(Player player) {
        Menu menu = new Menu("Current Games", 27);
        int column = 0;
        int row = 0;
        for (GameManager.GameHolder holder : Warlords.getGameManager().getGames()) {
            Game game = holder.getGame();
            if (game == null || !game.acceptsSpectators()) continue;
            menu.setItem(column, row, new ItemBuilder(Material.BOOK).name(ChatColor.GREEN + "Game - ID: " + game.getGameId()).lore(ChatColor.GRAY + "Map: " + ChatColor.RED + game.getMap().getMapName(), ChatColor.GRAY + "Gamemode: " + ChatColor.RED + game.getGameMode().name, ChatColor.GRAY + "Addons: " + ChatColor.RED + game.getAddons().stream().map(e -> Utils.toTitleHumanCase(e.name())).collect(Collectors.joining(", ")), ChatColor.GRAY + "Player count: " + ChatColor.RED + game.playersCount()).get(), (m4, e) -> {
                if (game.isClosed()) {
                    player.sendMessage(ChatColor.RED + "This game is no longer running");
                    SpectateCommand.openSpectateMenu(player);
                    return;
                }
                if (!game.acceptsSpectators()) {
                    player.sendMessage(ChatColor.RED + "This game does not accepts spectators");
                    SpectateCommand.openSpectateMenu(player);
                    return;
                }
                Optional<Game> currentGame = Warlords.getGameManager().getPlayerGame(player.getUniqueId());
                if (currentGame.isPresent() && currentGame.get().getPlayerTeam(player.getUniqueId()) != null) {
                    player.sendMessage(ChatColor.RED + "You cannot use this command inside a game!");
                } else if (currentGame.isPresent() && currentGame.get().equals(game)) {
                    player.sendMessage(ChatColor.RED + "You are already spectating this game");
                } else {
                    if (currentGame.isPresent()) {
                        currentGame.get().removePlayer(player.getUniqueId());
                    }
                    game.addPlayer((OfflinePlayer)player, true);
                }
            });
            if (++column <= 8) continue;
            column = 0;
            ++row;
        }
        Optional<Game> currentGame = Warlords.getGameManager().getPlayerGame(player.getUniqueId());
        if (currentGame.isPresent()) {
            menu.setItem(4, 2, new ItemBuilder(Material.BARRIER).name(ChatColor.GREEN + "Return to the lobby").get(), (m4, e) -> {
                Optional<Game> currentGame1 = Warlords.getGameManager().getPlayerGame(player.getUniqueId());
                if (currentGame1.isPresent() && currentGame1.get().getPlayerTeam(player.getUniqueId()) != null) {
                    player.sendMessage(ChatColor.RED + "You cannot use this command inside a game!");
                } else {
                    currentGame1.get().removePlayer(player.getUniqueId());
                }
            });
        }
        menu.openForPlayer(player);
    }
}

