/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.miscellaneouscommands;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.BaseCommand;
import com.ebicep.warlords.commands.debugcommands.misc.MuteCommand;
import com.ebicep.warlords.commands.miscellaneouscommands.PlayerMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MessageCommand
implements CommandExecutor {
    public static final LinkedHashMap<PlayerMessage, Long> lastPlayerMessages = new LinkedHashMap();

    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        Player player = BaseCommand.requirePlayer(sender);
        if (player == null) {
            return true;
        }
        if (MuteCommand.mutedPlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return true;
        }
        switch (s2) {
            case "tell": 
            case "msg": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Invalid Parameters! /msg (player) (message)");
                    return true;
                }
                String targetPlayer = args[0];
                Player otherPlayer = Bukkit.getPlayer((String)targetPlayer);
                if (otherPlayer != null) {
                    if (otherPlayer.equals(player)) {
                        sender.sendMessage(ChatColor.RED + "You cannot message yourself");
                        return true;
                    }
                    StringBuilder message = new StringBuilder();
                    for (int i = 1; i < args.length; ++i) {
                        message.append(args[i]).append(" ");
                    }
                    sender.sendMessage(ChatColor.DARK_PURPLE + "To " + ChatColor.AQUA + otherPlayer.getName() + ChatColor.WHITE + ": " + ChatColor.LIGHT_PURPLE + message);
                    otherPlayer.sendMessage(ChatColor.DARK_PURPLE + "From " + ChatColor.AQUA + sender.getName() + ChatColor.WHITE + ": " + ChatColor.LIGHT_PURPLE + message);
                    PlayerMessage newPlayerMessage = new PlayerMessage(player.getUniqueId(), otherPlayer.getUniqueId());
                    lastPlayerMessages.put(newPlayerMessage, System.currentTimeMillis());
                    return true;
                }
                sender.sendMessage(ChatColor.RED + "Cannot find that player");
                return true;
            }
            case "r": {
                if (args.length < 1) {
                    sender.sendMessage(ChatColor.RED + "Invalid Parameters! /r (message)");
                    return true;
                }
                Optional<PlayerMessage> playerMessage = lastPlayerMessages.entrySet().stream().filter(playerMessageLongEntry -> ((PlayerMessage)playerMessageLongEntry.getKey()).getTo().equals(player.getUniqueId())).sorted((o1, o2) -> Long.compare((Long)o2.getValue(), (Long)o1.getValue())).map(Map.Entry::getKey).findFirst();
                if (playerMessage.isPresent()) {
                    StringBuilder message = new StringBuilder();
                    for (String arg : args) {
                        message.append(arg).append(" ");
                    }
                    Player otherPlayer = Bukkit.getPlayer((UUID)playerMessage.get().getFrom());
                    if (otherPlayer != null) {
                        sender.sendMessage(ChatColor.DARK_PURPLE + "To " + ChatColor.AQUA + otherPlayer.getName() + ChatColor.WHITE + ": " + ChatColor.LIGHT_PURPLE + message);
                        otherPlayer.sendMessage(ChatColor.DARK_PURPLE + "From " + ChatColor.AQUA + sender.getName() + ChatColor.WHITE + ": " + ChatColor.LIGHT_PURPLE + message);
                        PlayerMessage newPlayerMessage = new PlayerMessage(player.getUniqueId(), otherPlayer.getUniqueId());
                        lastPlayerMessages.put(newPlayerMessage, System.currentTimeMillis());
                        return true;
                    }
                    sender.sendMessage(ChatColor.RED + "That player is no longer online");
                    return true;
                }
                sender.sendMessage(ChatColor.RED + "Nobody has messages you within the last 5 minutes");
                return true;
            }
        }
        return true;
    }

    public void register(Warlords instance) {
        instance.getCommand("msg").setExecutor((CommandExecutor)this);
        new BukkitRunnable(){

            public void run() {
                lastPlayerMessages.entrySet().removeIf(playerMessageLongEntry -> System.currentTimeMillis() - (Long)playerMessageLongEntry.getValue() >= 300000L);
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 40L, 6000L);
    }
}

