/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.misc;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.BaseCommand;
import com.ebicep.warlords.database.DatabaseManager;
import com.ebicep.warlords.database.cache.MultipleCacheResolver;
import com.ebicep.warlords.database.repositories.player.PlayersCollections;
import com.ebicep.warlords.database.repositories.player.pojos.AbstractDatabaseStatInformation;
import com.ebicep.warlords.database.repositories.player.pojos.general.DatabasePlayer;
import com.ebicep.warlords.player.SpecType;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.signgui.SignGUI;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.springframework.cache.caffeine.CaffeineCache;

public class TestCommand
implements CommandExecutor {
    private static void printCache() {
        Object cache = ((CaffeineCache)MultipleCacheResolver.playersCacheManager.getCache(PlayersCollections.LIFETIME.cacheName)).getNativeCache();
        System.out.println("CACHE - " + cache.asMap());
    }

    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        if (!sender.hasPermission("warlords.game.test")) {
            sender.sendMessage("\u00a7cYou do not have permission to do that.");
            return true;
        }
        WarlordsPlayer warlordsPlayer = BaseCommand.requireWarlordsPlayer(sender);
        if (warlordsPlayer != null) {
            // empty if block
        }
        SignGUI.open((Player)sender, new String[]{"1", "2", "3"}, (player, lines) -> System.out.println(Arrays.toString(lines)));
        Player player2 = (Player)sender;
        sender.sendMessage(ChatColor.GREEN + "DID THE THING");
        return true;
    }

    private void updateStats(DatabasePlayer databasePlayer, long damageExp, long tankEXP, long healerExp, long totalExp, PlayersCollections playersCollections) {
        DatabaseManager.updatePlayerAsync(databasePlayer, playersCollections);
    }

    private long getExp(AbstractDatabaseStatInformation information, SpecType specType, long caps, long rets) {
        double absorbedMultiplier;
        double healingMultiplier;
        double damageMultiplier;
        if (specType == SpecType.DAMAGE) {
            damageMultiplier = 0.8;
            healingMultiplier = 0.1;
            absorbedMultiplier = 0.1;
        } else if (specType == SpecType.HEALER) {
            damageMultiplier = 0.275;
            healingMultiplier = 0.65;
            absorbedMultiplier = 0.75;
        } else {
            damageMultiplier = 0.575;
            healingMultiplier = 0.1;
            absorbedMultiplier = 0.325;
        }
        double calculatedDHP = (double)information.getDamage() * damageMultiplier + (double)information.getHealing() * healingMultiplier + (double)information.getAbsorbed() * absorbedMultiplier;
        long exp = 0L;
        exp += (long)information.getWins() * 50L + (long)information.getLosses() * 25L;
        exp += (long)(information.getKills() + information.getAssists()) * 5L;
        exp = (long)((double)exp + calculatedDHP / 5000.0);
        exp += caps * 15L;
        return exp += rets * 5L;
    }

    public void register(Warlords instance) {
        instance.getCommand("test").setExecutor((CommandExecutor)this);
    }
}

