/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.misc;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.database.repositories.games.pojos.DatabaseGameBase;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class GamesCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        if (!sender.hasPermission("warlords.game.lookupgame")) {
            sender.sendMessage("\u00a7cYou do not have permission to do that.");
            return true;
        }
        if (args.length == 0) {
            StringBuilder stringBuilder = new StringBuilder(ChatColor.GREEN + "Previous Games - \n");
            for (int i = 0; i < DatabaseGameBase.previousGames.size(); ++i) {
                stringBuilder.append(ChatColor.YELLOW).append(i).append(". ").append(DatabaseGameBase.previousGames.get(i).getGameLabel()).append("\n");
            }
            sender.sendMessage(stringBuilder.toString());
            return true;
        }
        if (args[0].equals("reload")) {
            sender.sendMessage(ChatColor.GREEN + "Deleting Holograms");
            DatabaseGameBase.previousGames.forEach(DatabaseGameBase::deleteHolograms);
            sender.sendMessage(ChatColor.GREEN + "Creating Holograms");
            DatabaseGameBase.previousGames.forEach(DatabaseGameBase::createHolograms);
            sender.sendMessage(ChatColor.GREEN + "Setting Visibility");
            Bukkit.getOnlinePlayers().forEach(DatabaseGameBase::setGameHologramVisibility);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Invalid Arguments! [add/remove] [gameNumber]");
            return true;
        }
        if (!NumberUtils.isNumber((String)args[1])) {
            sender.sendMessage(ChatColor.RED + "Invalid game number!");
            return true;
        }
        int gameNumber = Integer.parseInt(args[1]);
        if (gameNumber >= DatabaseGameBase.previousGames.size() || gameNumber < 0) {
            sender.sendMessage(ChatColor.RED + "Invalid game number!");
            return true;
        }
        String input = args[0];
        switch (input.toLowerCase()) {
            case "add": {
                DatabaseGameBase.addGameToDatabase(DatabaseGameBase.previousGames.get(gameNumber));
                sender.sendMessage(ChatColor.GREEN + "Adding game!");
                return true;
            }
            case "remove": {
                DatabaseGameBase.removeGameFromDatabase(DatabaseGameBase.previousGames.get(gameNumber));
                sender.sendMessage(ChatColor.RED + "Removing game!");
                return true;
            }
        }
        return true;
    }

    public void register(Warlords instance) {
        instance.getCommand("games").setExecutor((CommandExecutor)this);
    }
}

