/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.ingame;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.BaseCommand;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.Team;
import com.ebicep.warlords.game.option.ImposterModeOption;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ImposterCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        if (args.length < 1) {
            return true;
        }
        String input = args[0];
        if (input.equalsIgnoreCase("assign") && !sender.hasPermission("warlords.game.impostertoggle")) {
            sender.sendMessage("\u00a7cYou do not have permission to do that.");
            return true;
        }
        switch (input.toLowerCase()) {
            case "assign": {
                WarlordsPlayer warlordsPlayer = BaseCommand.requireWarlordsPlayer(sender);
                if (warlordsPlayer == null) {
                    return true;
                }
                if (warlordsPlayer.getGame().getAddons().contains((Object)GameAddon.IMPOSTER_MODE)) break;
                sender.sendMessage(ChatColor.RED + "The imposter gamemode is currently disabled");
                return true;
            }
            case "vote": {
                WarlordsPlayer warlordsPlayer = BaseCommand.requireWarlordsPlayer(sender);
                if (warlordsPlayer == null) {
                    return true;
                }
                if (!warlordsPlayer.getGame().getAddons().contains((Object)GameAddon.IMPOSTER_MODE)) {
                    sender.sendMessage(ChatColor.RED + "The imposter gamemode is currently disabled");
                    return true;
                }
                if (warlordsPlayer.getGameState().getTicksElapsed() < 6000) {
                    sender.sendMessage(ChatColor.RED + "You cannot request to vote before 5 minutes have past!");
                    return true;
                }
                ImposterModeOption imposterModeOption = (ImposterModeOption)warlordsPlayer.getGame().getOptions().stream().filter(option -> option instanceof ImposterModeOption).findFirst().get();
                if (imposterModeOption.getPoll() != null) {
                    sender.sendMessage(ChatColor.GREEN + "There is an ongoing poll!");
                    return true;
                }
                if (imposterModeOption.getVoters().values().stream().anyMatch(warlordsPlayers -> warlordsPlayers.contains(warlordsPlayer))) {
                    sender.sendMessage(ChatColor.RED + "You already voted to vote!");
                    return true;
                }
                imposterModeOption.getVoters().computeIfAbsent(warlordsPlayer.getTeam(), v -> new ArrayList()).add(warlordsPlayer);
                int votesNeeded = (int)((double)warlordsPlayer.getGame().getPlayers().entrySet().stream().filter(uuidTeamEntry -> uuidTeamEntry.getValue() == warlordsPlayer.getTeam()).count() * 0.75 + 1.0);
                if (votesNeeded >= imposterModeOption.getVoters().get((Object)warlordsPlayer.getTeam()).size()) {
                    Team team2 = warlordsPlayer.getTeam();
                    imposterModeOption.sendPoll(team2);
                    warlordsPlayer.getGame().addFrozenCause(team2.teamColor + team2.name + ChatColor.GREEN + " is voting!");
                    break;
                }
                warlordsPlayer.getGame().forEachOnlinePlayerWithoutSpectators((player, team) -> {
                    if (team == warlordsPlayer.getTeam()) {
                        player.sendMessage(ChatColor.GREEN + "A player wants to vote out someone! (" + imposterModeOption.getVoters().get((Object)warlordsPlayer.getTeam()).size() + "/" + votesNeeded + ")");
                    }
                });
                break;
            }
        }
        return true;
    }

    public void register(Warlords instance) {
        instance.getCommand("imposter").setExecutor((CommandExecutor)this);
    }
}

