/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.game;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.debugcommands.game.GameTargetCommand;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.game.state.EndState;
import com.ebicep.warlords.game.state.PlayingState;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;

public class GameTerminateCommand
extends GameTargetCommand
implements TabExecutor {
    @Override
    protected void doAction(CommandSender sender, Collection<GameManager.GameHolder> gameInstances) {
        sender.sendMessage(ChatColor.RED + "DEV:" + ChatColor.GRAY + " Requesting engine to terminate games...");
        if (gameInstances.isEmpty()) {
            sender.sendMessage(ChatColor.RED + "No valid targets found!");
            return;
        }
        for (GameManager.GameHolder holder : gameInstances) {
            Optional<PlayingState> state;
            Game game = holder.getGame();
            if (game == null) {
                sender.sendMessage(ChatColor.GRAY + "- " + holder.getName() + ": " + ChatColor.RED + "The game is not active now");
                continue;
            }
            if (holder.getGame().isFrozen()) {
                holder.getGame().clearFrozenCauses();
            }
            if (!(state = game.getState(PlayingState.class)).isPresent()) {
                sender.sendMessage(ChatColor.GRAY + "- " + holder.getName() + ": " + ChatColor.RED + "The game is not in playing state, instead it is in " + game.getState().getClass().getSimpleName());
                continue;
            }
            sender.sendMessage(ChatColor.GRAY + "- " + holder.getName() + ": " + ChatColor.RED + "Terminating game...");
            game.setNextState(new EndState(game, null));
        }
        sender.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + "Game has been terminated. Warping back to lobby...");
    }

    public void register(Warlords instance) {
        instance.getCommand("terminategame").setExecutor((CommandExecutor)this);
        instance.getCommand("terminategame").setTabCompleter((TabCompleter)this);
    }
}

