/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.game;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.commands.BaseCommand;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public abstract class GameTargetCommand
implements TabExecutor {
    protected abstract void doAction(CommandSender var1, Collection<GameManager.GameHolder> var2);

    protected Collection<GameManager.GameHolder> getGames() {
        return Warlords.getGameManager().getGames();
    }

    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        Collection<GameManager.GameHolder> gameInstances;
        if (!command.testPermissionSilent(sender)) {
            sender.sendMessage("\u00a7cYou do not have permission to do that.");
            return true;
        }
        if (args.length == 0) {
            WarlordsPlayer wp = BaseCommand.requireWarlordsPlayer(sender);
            if (wp == null) {
                return true;
            }
            gameInstances = this.getGames().stream().filter(e -> e.getGame() == wp.getGame()).collect(Collectors.toList());
            if (gameInstances.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "Unable to find the game that your are in!");
            }
        } else {
            HashSet holder = new HashSet();
            gameInstances = holder;
            ArrayList<GameManager.GameHolder> matched = new ArrayList<GameManager.GameHolder>();
            if (sender.hasPermission("warlords.game.end.remote")) {
                for (String arg : args) {
                    matched.clear();
                    for (GameManager.GameHolder h2 : this.getGames()) {
                        Game game = h2.getGame();
                        if (!"*".equals(arg) && !h2.getName().equalsIgnoreCase(arg) && !h2.getMap().name().equalsIgnoreCase(arg) && (game == null || !game.getGameMode().name().equalsIgnoreCase(arg)) && (game == null || !game.getGameId().toString().equalsIgnoreCase(arg))) continue;
                        matched.add(h2);
                    }
                    if (matched.isEmpty()) {
                        sender.sendMessage(ChatColor.RED + "Unable to find: " + arg);
                        continue;
                    }
                    holder.addAll(matched);
                }
            } else {
                sender.sendMessage(ChatColor.RED + "You do not have permission to remotely end games.");
            }
        }
        this.doAction(sender, gameInstances);
        return true;
    }

    public List<String> onTabComplete(CommandSender cs, Command cmnd, String label, String[] args) {
        return Stream.concat(Stream.of("*"), Warlords.getGameManager().getGames().stream().flatMap(h2 -> Stream.concat(Stream.of(Utils.toTitleCase(h2.getName()), Utils.toTitleCase(h2.getMap().name())), h2.getGame() != null ? Stream.of(h2.getGame().getGameId().toString(), Utils.toTitleCase(h2.getGame().getGameMode().name())) : Stream.empty())).distinct()).filter(e -> Utils.startsWithIgnoreCase(e, args[args.length - 1])).collect(Collectors.toList());
    }
}

