/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands.debugcommands.game;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.game.GameManager;
import com.ebicep.warlords.game.GameMap;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.party.Party;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class GameStartCommand
implements TabExecutor {
    @Nullable
    private static GameManager.QueueEntryBuilder buildQueue(@Nonnull List<? extends OfflinePlayer> people, @Nonnull CommandSender sender, @Nonnull String[] args) {
        GameMap map = null;
        Enum category = null;
        EnumSet<GameAddon> addon = EnumSet.of(GameAddon.PRIVATE_GAME);
        ArrayList<Player> selectedPeople = null;
        GameMap[] maps = GameMap.values();
        GameMode[] categories = GameMode.values();
        GameAddon[] addons = GameAddon.values();
        boolean isValid = true;
        boolean seenMapOrCategory = false;
        block16: for (String arg : args) {
            int indexOf = arg.indexOf(58);
            if (indexOf < 0) {
                GameAddon foundAddon;
                GameMode foundCategory;
                GameMap foundMap = Utils.arrayGetItem(maps, e -> e.name().equalsIgnoreCase(arg));
                if ((foundMap == null ? 0 : 1) + ((foundCategory = Utils.arrayGetItem(categories, e -> e.name().equalsIgnoreCase(arg))) == null ? 0 : 1) + ((foundAddon = Utils.arrayGetItem(addons, e -> e.name().equalsIgnoreCase(arg))) == null ? 0 : 1) > 1) {
                    sender.sendMessage(ChatColor.RED + "Vague option: " + arg);
                    isValid = false;
                    if (foundMap != null) {
                        sender.sendMessage("Prepend map: to specify the map with this name");
                    }
                    if (foundCategory != null) {
                        sender.sendMessage("Prepend category: to specify the category with this name");
                    }
                    if (foundAddon == null) continue;
                    sender.sendMessage("Prepend addon: to specify the addon with this name");
                    continue;
                }
                if (foundMap != null) {
                    map = foundMap;
                    seenMapOrCategory = true;
                    continue;
                }
                if (foundCategory != null) {
                    category = foundCategory;
                    seenMapOrCategory = true;
                    continue;
                }
                if (foundAddon != null) {
                    if (addon.isEmpty()) {
                        addon = EnumSet.of(foundAddon);
                        continue;
                    }
                    addon.add(foundAddon);
                    continue;
                }
                sender.sendMessage(ChatColor.RED + "Invalid addon! " + arg);
                isValid = false;
                continue;
            }
            String argType = arg.substring(0, indexOf);
            String argData = arg.substring(indexOf + 1);
            switch (argType.toLowerCase(Locale.ROOT)) {
                case "map": {
                    GameMap foundMap = Utils.arrayGetItem(maps, e -> e.name().equalsIgnoreCase(argData));
                    if (foundMap != null) {
                        map = foundMap;
                    } else if (argData.equalsIgnoreCase("null")) {
                        map = null;
                    } else {
                        sender.sendMessage(ChatColor.RED + "Map not found: " + argData);
                        isValid = false;
                    }
                    seenMapOrCategory = true;
                    continue block16;
                }
                case "category": {
                    GameMode foundCategory = Utils.arrayGetItem(categories, e -> e.name().equalsIgnoreCase(argData));
                    if (foundCategory != null) {
                        category = foundCategory;
                    } else if (argData.equalsIgnoreCase("null")) {
                        category = null;
                    } else {
                        sender.sendMessage(ChatColor.RED + "Category not found: " + argData);
                        isValid = false;
                    }
                    seenMapOrCategory = true;
                    continue block16;
                }
                case "addon": {
                    GameAddon foundAddon = Utils.arrayGetItem(addons, e -> e.name().equalsIgnoreCase(argData));
                    if (foundAddon != null) {
                        if (addon.isEmpty()) {
                            addon = EnumSet.of(foundAddon);
                            continue block16;
                        }
                        addon.add(foundAddon);
                        continue block16;
                    }
                    if (argData.equalsIgnoreCase("null")) {
                        addon = EnumSet.noneOf(GameAddon.class);
                        continue block16;
                    }
                    sender.sendMessage(ChatColor.RED + "Addon not found: " + argData);
                    isValid = false;
                    continue block16;
                }
                case "player": 
                case "players": 
                case "offline-player": {
                    Player p;
                    if (!sender.hasPermission("warlords.game.start.players")) {
                        sender.sendMessage("You do not have permissions to invite players outside your party: " + arg);
                        isValid = false;
                        continue block16;
                    }
                    boolean allowOfflinePlayer = argType.equals("offline-player");
                    int length = argData.length();
                    if (argData.equals("*")) {
                        if (selectedPeople == null) {
                            selectedPeople = new ArrayList<Player>();
                        }
                        selectedPeople.addAll(Bukkit.getOnlinePlayers());
                        continue block16;
                    }
                    if (length <= 16) {
                        p = Bukkit.getPlayer((String)argData);
                        if (p == null) {
                            sender.sendMessage(ChatColor.RED + "Player not online: " + argData + " specify offline-player:<uuid> to target offline players");
                            isValid = false;
                        }
                    } else if (length == 32 || length == 36) {
                        try {
                            UUID id = UUID.fromString(length == 32 ? argData.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5") : argData);
                            p = allowOfflinePlayer ? Bukkit.getOfflinePlayer((UUID)id) : Bukkit.getPlayer((UUID)id);
                        }
                        catch (IllegalArgumentException e2) {
                            p = null;
                            sender.sendMessage(ChatColor.RED + "Invalid UUID: " + argData);
                            isValid = false;
                        }
                    } else {
                        p = null;
                        sender.sendMessage(ChatColor.RED + "Invalid name/UUID: " + argData);
                        isValid = false;
                    }
                    if (p == null) continue block16;
                    if (selectedPeople == null) {
                        selectedPeople = new ArrayList();
                    }
                    selectedPeople.add(p);
                    continue block16;
                }
                default: {
                    sender.sendMessage(ChatColor.RED + "Unknown option type: " + argType + " in " + arg);
                    isValid = false;
                }
            }
        }
        if (category != null && map != null && !map.getGameModes().contains(category)) {
            sender.sendMessage(ChatColor.RED + "map:" + Utils.toTitleCase((Object)map) + " is not part of category:" + Utils.toTitleCase(category) + ", valid maps: " + Arrays.toString((Object[])GameMap.values()));
            isValid = false;
        }
        if (category == null && map == null && !seenMapOrCategory) {
            sender.sendMessage(ChatColor.RED + "Creating a game with no category and map is unusual, pass category:null or map:null if you really mean this.");
            isValid = false;
        }
        for (GameAddon a : addon) {
            if (a.hasPermission(sender)) continue;
            sender.sendMessage(ChatColor.RED + "You do not have the permission to use addon: " + Utils.toTitleCase(a.name()));
            isValid = false;
        }
        if (!isValid) {
            return null;
        }
        sender.sendMessage(ChatColor.RED + "DEV:" + ChatColor.GRAY + " Requesting a game with the following parameters:");
        if (category != null) {
            sender.sendMessage(ChatColor.GRAY + "- Category: " + ChatColor.RED + Utils.toTitleHumanCase(category.name()));
        }
        if (map != null) {
            sender.sendMessage(ChatColor.GRAY + "- Map: " + ChatColor.RED + Utils.toTitleHumanCase(map.name()));
        }
        if (!addon.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "- Game Addons: " + ChatColor.GOLD + addon.stream().map(e -> Utils.toTitleHumanCase(e.name())).collect(Collectors.joining(", ")));
        }
        if (selectedPeople != null) {
            sender.sendMessage(ChatColor.GRAY + "- Players: " + ChatColor.RED + selectedPeople.stream().map(OfflinePlayer::getName).collect(Collectors.joining(", ")));
        }
        return Warlords.getGameManager().newEntry(selectedPeople == null ? people : selectedPeople).setCategory((GameMode)category).setMap(map).setRequestedGameAddons(addon);
    }

    public static void startGame(Player sender, String[] args) {
        GameManager.QueueEntryBuilder queueEntry;
        Optional<Party> party = Warlords.partyManager.getPartyFromAny(sender.getUniqueId());
        List people = party.map(Party::getAllPartyPeoplePlayerOnline).orElseGet(() -> Collections.singletonList(sender));
        if (party.isPresent()) {
            if (!party.get().getPartyLeader().getUuid().equals(sender.getUniqueId())) {
                sender.sendMessage(ChatColor.RED + "You are not the party leader");
                return;
            }
            if (!party.get().allOnlineAndNoAFKs()) {
                sender.sendMessage(ChatColor.RED + "All party members must be online or not afk");
                return;
            }
        }
        if ((queueEntry = GameStartCommand.buildQueue(people, (CommandSender)sender, args)) == null) {
            return;
        }
        Pair<GameManager.QueueResult, Game> result = queueEntry.setPriority(-10).queueNow();
        Game game = result.getB();
        if (game == null) {
            sender.sendMessage(ChatColor.RED + "DEV:" + ChatColor.GRAY + " Engine failed to find a game server suiteable for your request:");
            sender.sendMessage(ChatColor.GRAY + result.getA().toString());
        } else {
            sender.sendMessage(ChatColor.RED + "DEV:" + ChatColor.GRAY + " Engine " + (result.getA() == GameManager.QueueResult.READY_NEW ? "initiated" : "found") + " a game with the following parameters:");
            sender.sendMessage(ChatColor.GRAY + "- Category: " + ChatColor.RED + Utils.toTitleHumanCase((Object)game.getGameMode()));
            sender.sendMessage(ChatColor.GRAY + "- Map: " + ChatColor.RED + Utils.toTitleHumanCase((Object)game.getMap()));
            sender.sendMessage(ChatColor.GRAY + "- Game Addons: " + ChatColor.GOLD + game.getAddons().stream().map(e -> Utils.toTitleHumanCase(e.name())).collect(Collectors.joining(", ")));
            sender.sendMessage(ChatColor.GRAY + "- Min players: " + ChatColor.RED + game.getMinPlayers());
            sender.sendMessage(ChatColor.GRAY + "- Max players: " + ChatColor.RED + game.getMaxPlayers());
            sender.sendMessage(ChatColor.GRAY + "- Open for public: " + ChatColor.RED + game.acceptsPeople());
            sender.sendMessage(ChatColor.GRAY + "- Game ID: " + ChatColor.RED + game.getGameId());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String s2, String[] args) {
        System.out.println(sender.getName() + " tried to use start command");
        sender.sendMessage(ChatColor.RED + "This command is disabled, use the " + (sender.hasPermission("warlords.game.debug") ? "emerald" : "blaze powder") + " to start a game.");
        return true;
    }

    public Stream<String> prefixedEnum(Enum<?>[] list, String prefix) {
        return Stream.concat(Stream.of(prefix + ":NULL"), Stream.concat(Stream.of(list).map(e -> Utils.toTitleCase(e.name())), Stream.of(list).map(e -> prefix + ":" + Utils.toTitleCase(e.name()))));
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s2, String[] args) {
        return new ArrayList<String>();
    }

    public void register(Warlords instance) {
        instance.getCommand("start").setExecutor((CommandExecutor)this);
        instance.getCommand("start").setTabCompleter((TabCompleter)this);
    }
}

