/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.commands;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.game.Game;
import com.ebicep.warlords.game.GameAddon;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BaseCommand {
    @Nullable
    public static Player requirePlayerOutsideGame(@Nonnull CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command requires a player!");
            return null;
        }
        if (Warlords.hasPlayer((OfflinePlayer)((Player)sender))) {
            sender.sendMessage(ChatColor.RED + "You cannot use this command inside a game!");
            return null;
        }
        return (Player)sender;
    }

    @Nullable
    public static Player requirePlayer(@Nonnull CommandSender sender) {
        return BaseCommand.requirePlayer(sender, null);
    }

    @Nullable
    public static Player requirePlayer(@Nonnull CommandSender sender, @Nullable String name) {
        if (name == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command requires a player!");
                return null;
            }
            return (Player)sender;
        }
        Player p = Bukkit.getPlayer((String)name);
        if (p == null) {
            sender.sendMessage(ChatColor.RED + "Player not found!");
        }
        return p;
    }

    @Nullable
    public static WarlordsPlayer requireWarlordsPlayer(@Nonnull CommandSender sender) {
        return BaseCommand.requireWarlordsPlayer(sender, null);
    }

    @Nullable
    public static WarlordsPlayer requireWarlordsPlayer(@Nonnull CommandSender sender, @Nullable String name) {
        Player p = BaseCommand.requirePlayer(sender, name);
        if (p == null) {
            return null;
        }
        WarlordsPlayer player = Warlords.getPlayer(p);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "You are not in an active game! Please wait until the game has started to use this command.");
        }
        return player;
    }

    @Nullable
    public static WarlordsPlayer requireWarlordsPlayerInPrivateGame(@Nonnull CommandSender sender) {
        return BaseCommand.requireWarlordsPlayerInPrivateGame(sender, null);
    }

    @Nullable
    public static WarlordsPlayer requireWarlordsPlayerInPrivateGame(@Nonnull CommandSender sender, @Nullable String name) {
        WarlordsPlayer player = BaseCommand.requireWarlordsPlayer(sender, name);
        if (player == null) {
            return null;
        }
        if (!player.getGame().getAddons().contains((Object)GameAddon.PRIVATE_GAME)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used in a private game!");
            return null;
        }
        return player;
    }

    @Nullable
    public static Game requireGame(@Nonnull CommandSender sender) {
        return BaseCommand.requireGame(sender, null);
    }

    @Nullable
    public static Game requireGame(@Nonnull CommandSender sender, @Nullable String name) {
        Player p = BaseCommand.requirePlayer(sender, name);
        if (p == null) {
            return null;
        }
        Optional<Game> playerGame = Warlords.getGameManager().getPlayerGame(((Player)sender).getUniqueId());
        if (!playerGame.isPresent()) {
            sender.sendMessage(ChatColor.RED + "You are not in a game!");
            return null;
        }
        return playerGame.get();
    }

    @Nullable
    public static Game requirePrivateGame(@Nonnull CommandSender sender) {
        return BaseCommand.requirePrivateGame(sender, null);
    }

    @Nullable
    public static Game requirePrivateGame(@Nonnull CommandSender sender, @Nullable String name) {
        Game g2 = BaseCommand.requireGame(sender, name);
        if (g2 == null) {
            return null;
        }
        if (!g2.getAddons().contains((Object)GameAddon.PRIVATE_GAME)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used in a private game!");
            return null;
        }
        return g2;
    }
}

