/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.classes;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.ArcaneShield;
import com.ebicep.warlords.abilties.EarthenSpike;
import com.ebicep.warlords.abilties.SoulShackle;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.TextComponentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractPlayerClass {
    protected int maxHealth;
    protected int maxEnergy;
    protected int energyPerSec;
    protected int energyOnHit;
    protected int damageResistance;
    protected AbstractAbility weapon;
    protected AbstractAbility red;
    protected AbstractAbility purple;
    protected AbstractAbility blue;
    protected AbstractAbility orange;
    protected boolean abilityCD = true;
    protected boolean secondaryAbilityCD = true;
    protected String name;
    protected String className;
    protected String classNameShort;

    public AbstractPlayerClass(String name, int maxHealth, int maxEnergy, int energyPerSec, int energyOnHit, int damageResistance, AbstractAbility weapon, AbstractAbility red, AbstractAbility purple, AbstractAbility blue, AbstractAbility orange) {
        this.maxHealth = maxHealth;
        this.maxEnergy = maxEnergy;
        this.energyPerSec = energyPerSec;
        this.energyOnHit = energyOnHit;
        this.damageResistance = damageResistance;
        this.weapon = weapon;
        this.red = red;
        this.purple = purple;
        this.blue = blue;
        this.orange = orange;
        this.name = name;
        if (blue instanceof ArcaneShield) {
            ArcaneShield arcaneShield = (ArcaneShield)blue;
            arcaneShield.setMaxShieldHealth((int)((float)maxHealth * ((float)arcaneShield.getShieldPercentage() / 100.0f)));
            blue.updateDescription(null);
        }
    }

    public List<TextComponent> getFormattedData() {
        ArrayList<TextComponent> textComponentList = new ArrayList<TextComponent>();
        ChatColor[] chatColors = new ChatColor[]{ChatColor.GREEN, ChatColor.RED, ChatColor.LIGHT_PURPLE, ChatColor.AQUA, ChatColor.GOLD, ChatColor.GRAY, ChatColor.GRAY, ChatColor.GRAY, ChatColor.GRAY};
        for (int i = 0; i < this.getAbilities().length; ++i) {
            AbstractAbility ability = this.getAbilities()[i];
            textComponentList.add(new TextComponentBuilder(chatColors[i] + ability.getName()).setHoverText(ability.getAbilityInfo().stream().map(stringStringPair -> ChatColor.WHITE + (String)stringStringPair.getA() + ": " + ChatColor.GOLD + (String)stringStringPair.getB()).collect(Collectors.joining("\n"))).getTextComponent());
        }
        return textComponentList;
    }

    public void onRightClick(@Nonnull WarlordsPlayer wp, @Nonnull Player player, int slot, boolean hotkeyMode) {
        if (wp.getGameState() != wp.getGame().getState()) {
            return;
        }
        if (wp.isDead()) {
            return;
        }
        if (!wp.getGame().isFrozen()) {
            switch (slot) {
                case 0: {
                    if (wp.getCooldownManager().hasCooldown(SoulShackle.class)) {
                        player.sendMessage(ChatColor.RED + "You have been silenced!");
                        player.playSound(player.getLocation(), "notreadyalert", 1.0f, 1.0f);
                        break;
                    }
                    if ((double)player.getLevel() >= (double)this.weapon.getEnergyCost() * wp.getEnergyModifier() && this.abilityCD) {
                        this.weapon.onActivate(wp, player);
                        if (!(this.weapon instanceof AbstractStrikeBase) && !(this.weapon instanceof EarthenSpike)) {
                            this.weapon.addTimesUsed();
                            AbstractPlayerClass.sendRightClickPacket(player);
                        }
                        this.resetAbilityCD();
                        break;
                    }
                    player.playSound(player.getLocation(), "notreadyalert", 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.onRightClickAbility(this.red, wp, player);
                    break;
                }
                case 2: {
                    this.onRightClickAbility(this.purple, wp, player);
                    break;
                }
                case 3: {
                    this.onRightClickAbility(this.blue, wp, player);
                    break;
                }
                case 4: {
                    this.onRightClickAbility(this.orange, wp, player);
                }
            }
            if ((slot == 0 || slot == 1 || slot == 2 || slot == 3 || slot == 4) && player.getVehicle() != null) {
                player.getVehicle().remove();
            }
        }
        if (hotkeyMode) {
            player.getInventory().setHeldItemSlot(0);
        }
    }

    private void onRightClickAbility(AbstractAbility ability, WarlordsPlayer wp, Player player) {
        if (ability.getCurrentCooldown() != 0.0f) {
            if (this.secondaryAbilityCD) {
                ability.runSecondAbilities();
                this.resetSecondaryAbilityCD();
            }
            return;
        }
        if ((double)player.getLevel() >= (double)ability.getEnergyCost() * wp.getEnergyModifier() && this.abilityCD) {
            boolean shouldApplyCooldown = ability.onActivate(wp, player);
            if (shouldApplyCooldown) {
                ability.addTimesUsed();
                ability.setCurrentCooldown((float)((double)ability.getCooldown() * wp.getCooldownModifier()));
                AbstractPlayerClass.sendRightClickPacket(player);
            }
            this.resetAbilityCD();
        }
    }

    private void resetAbilityCD() {
        this.abilityCD = false;
        new BukkitRunnable(){

            public void run() {
                AbstractPlayerClass.this.abilityCD = true;
            }
        }.runTaskLater((Plugin)Warlords.getInstance(), 1L);
    }

    private void resetSecondaryAbilityCD() {
        this.secondaryAbilityCD = false;
        new BukkitRunnable(){

            public void run() {
                AbstractPlayerClass.this.secondaryAbilityCD = true;
            }
        }.runTaskLater((Plugin)Warlords.getInstance(), 5L);
    }

    public static void sendRightClickPacket(Player player) {
        PacketPlayOutAnimation playOutAnimation = new PacketPlayOutAnimation((Entity)((CraftPlayer)player).getHandle(), 0);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)playOutAnimation);
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setMaxEnergy(int maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public int getEnergyPerSec() {
        return this.energyPerSec;
    }

    public void setEnergyPerSec(int energyPerSec) {
        this.energyPerSec = energyPerSec;
    }

    public int getEnergyOnHit() {
        return this.energyOnHit;
    }

    public void setEnergyOnHit(int energyOnHit) {
        this.energyOnHit = energyOnHit;
    }

    public int getDamageResistance() {
        return this.damageResistance;
    }

    public void setDamageResistance(int damageResistance) {
        this.damageResistance = damageResistance;
    }

    public AbstractAbility[] getAbilities() {
        return new AbstractAbility[]{this.weapon, this.red, this.purple, this.blue, this.orange};
    }

    public AbstractAbility getWeapon() {
        return this.weapon;
    }

    public AbstractAbility getRed() {
        return this.red;
    }

    public AbstractAbility getPurple() {
        return this.purple;
    }

    public AbstractAbility getBlue() {
        return this.blue;
    }

    public AbstractAbility getOrange() {
        return this.orange;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNameShort() {
        return this.classNameShort;
    }

    public String getClassNameShortWithBrackets() {
        return ChatColor.DARK_GRAY + "[" + ChatColor.GOLD + this.classNameShort + ChatColor.DARK_GRAY + "]";
    }

    public void runEverySecond() {
        this.red.runEverySecond();
        this.blue.runEverySecond();
        this.orange.runEverySecond();
        this.purple.runEverySecond();
        this.weapon.runEverySecond();
    }
}

