/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.achievements.types;

import com.ebicep.warlords.abilties.ArcaneShield;
import com.ebicep.warlords.abilties.CapacitorTotem;
import com.ebicep.warlords.abilties.IceBarrier;
import com.ebicep.warlords.abilties.ImpalingStrike;
import com.ebicep.warlords.abilties.InspiringPresence;
import com.ebicep.warlords.abilties.Intervene;
import com.ebicep.warlords.abilties.LastStand;
import com.ebicep.warlords.abilties.SoulShackle;
import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.UndyingArmy;
import com.ebicep.warlords.achievements.Achievement;
import com.ebicep.warlords.events.WarlordsDamageHealingFinalEvent;
import com.ebicep.warlords.game.GameMode;
import com.ebicep.warlords.player.Specializations;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.bukkit.WordWrap;
import com.ebicep.warlords.util.chat.ChatUtils;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public enum ChallengeAchievements implements Achievement
{
    REJUVENATION("Rejuvenation", "Heal your flag carrier from below 1k health to their maximum health capacity or above in 3 seconds.", GameMode.CAPTURE_THE_FLAG, null, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent event;
        int i;
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(3);
        WarlordsPlayer carrier = null;
        int below1000Index = -1;
        int fullHealthIndex = -1;
        for (i = 0; i < events.size(); ++i) {
            event = events.get(i);
            if (!event.isHasFlag() || event.getInitialHealth() > 1000) continue;
            below1000Index = i;
            carrier = event.getPlayer();
            break;
        }
        if (below1000Index != -1) {
            for (i = below1000Index; i < events.size(); ++i) {
                event = events.get(i);
                if (event.getPlayer() != carrier || !event.isHasFlag() || event.getFinalHealth() < carrier.getMaxHealth()) continue;
                fullHealthIndex = i;
                break;
            }
        } else {
            return false;
        }
        if (fullHealthIndex != -1) {
            ArrayList<WarlordsDamageHealingFinalEvent> healingEvents = new ArrayList<WarlordsDamageHealingFinalEvent>();
            for (int i2 = below1000Index; i2 <= fullHealthIndex; ++i2) {
                healingEvents.add(events.get(i2));
            }
            return (float)healingEvents.stream().filter(WarlordsDamageHealingFinalEvent::isHealingInstance).map(WarlordsDamageHealingFinalEvent::getValue).mapToDouble(Float::doubleValue).sum() >= 2000.0f;
        }
        return false;
    }, true),
    BLITZKRIEG("Blitzkrieg", "Kill the enemy flag carrier within 2 seconds.", GameMode.CAPTURE_THE_FLAG, null, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent event;
        int i;
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(2);
        int indexCarrierFull = -1;
        int indexCarrierDead = -1;
        for (i = 0; i < events.size(); ++i) {
            event = events.get(i);
            if (!event.isHasFlag() && !(event.getValue() >= (float)event.getInitialHealth()) || event.getInitialHealth() < event.getPlayer().getMaxHealth()) continue;
            indexCarrierFull = i;
            break;
        }
        if (indexCarrierFull != -1) {
            for (i = indexCarrierFull; i < events.size(); ++i) {
                event = events.get(i);
                if (!event.isDead()) continue;
                indexCarrierDead = i;
                break;
            }
        } else {
            return false;
        }
        if (indexCarrierDead != -1) {
            ArrayList<WarlordsDamageHealingFinalEvent> damageEvents = new ArrayList<WarlordsDamageHealingFinalEvent>();
            for (int i2 = indexCarrierFull; i2 <= indexCarrierDead; ++i2) {
                damageEvents.add(events.get(i2));
            }
            return (float)damageEvents.stream().filter(WarlordsDamageHealingFinalEvent::isDamageInstance).map(WarlordsDamageHealingFinalEvent::getValue).mapToDouble(Float::doubleValue).sum() >= 2000.0f;
        }
        return false;
    }, true),
    SNIPE_SHOT("Snipe Shot", "Kill the enemy flag carrier while being at least 30 blocks away from them.", GameMode.CAPTURE_THE_FLAG, Specializations.PYROMANCER, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent lastEvent = warlordsPlayer.getSecondStats().getLastEventAsAttacker();
        return lastEvent.isDead() && lastEvent.isHasFlag() && lastEvent.getPlayer().getLocation().distanceSquared(lastEvent.getAttacker().getLocation()) > 900.0;
    }, false),
    DUCK_TANK("Duck Tank", "Tank 9000 damage without losing health while holding the flag.", GameMode.CAPTURE_THE_FLAG, Specializations.CRYOMANCER, warlordsPlayer -> {
        List events = warlordsPlayer.getSecondStats().getEventsAsSelfFromLastSecond(10).stream().filter(WarlordsDamageHealingFinalEvent::isDamageInstance).collect(Collectors.toList());
        if (events.isEmpty()) {
            return false;
        }
        int lastHealth = ((WarlordsDamageHealingFinalEvent)((Object)((Object)events.get(0)))).getFinalHealth();
        float totalAbsorbed = 0.0f;
        for (WarlordsDamageHealingFinalEvent event : events) {
            if (event.isHasFlag() && lastHealth == event.getFinalHealth()) {
                if (!((totalAbsorbed += event.getValue()) >= 9000.0f)) continue;
                return true;
            }
            lastHealth = event.getFinalHealth();
            totalAbsorbed = 0.0f;
        }
        return false;
    }, false),
    CLERICAL_PRODIGY("Clerical Prodigy", "Heal your carrier for over 80k damage within a game.", GameMode.CAPTURE_THE_FLAG, Specializations.AQUAMANCER, warlordsPlayer -> warlordsPlayer.getMinuteStats().total().getHealingOnCarrier() >= 80000L, false),
    ASSASSINATE("Assassinate", "Land 7 critical hits on the enemy carrier in a row.", GameMode.CAPTURE_THE_FLAG, Specializations.ASSASSIN, warlordsPlayer -> {
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(10);
        int critsOnCarrier = 0;
        for (WarlordsDamageHealingFinalEvent event : events) {
            if (event.isCrit() && event.isHasFlag()) {
                if (++critsOnCarrier != 7) continue;
                return true;
            }
            critsOnCarrier = 0;
        }
        return false;
    }, false),
    SILENCE_PEON("Silence, peon!", "Kill the enemy flag carrier (that you silenced) while the silence duration is still up. ", GameMode.CAPTURE_THE_FLAG, Specializations.VINDICATOR, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent lastDamageEvent = warlordsPlayer.getSecondStats().getLastEventAsAttacker();
        if (lastDamageEvent.isDead()) {
            return new CooldownFilter<RegularCooldown>(lastDamageEvent.getPlayer(), RegularCooldown.class).filterCooldownFrom((WarlordsPlayer)warlordsPlayer).filterCooldownClassAndMapToObjectsOfClass(SoulShackle.class).findAny().isPresent();
        }
        return false;
    }, false),
    LYCHEESIS("Lycheesis", "Generate over 3k healing by inflicting one instance of LEECH on the enemy flag carrier.", GameMode.CAPTURE_THE_FLAG, Specializations.APOTHECARY, warlordsPlayer -> PlayerFilter.playingGame(warlordsPlayer.getGame()).enemiesOf((WarlordsPlayer)warlordsPlayer).filter(enemy -> new CooldownFilter<RegularCooldown>((WarlordsPlayer)enemy, RegularCooldown.class).filterCooldownFrom((WarlordsPlayer)warlordsPlayer).filterCooldownClassAndMapToObjectsOfClass(ImpalingStrike.class).anyMatch(impalingStrike -> impalingStrike.getHealingDoneFromEnemyCarrier() >= 3000.0f)).findAny().isPresent(), false),
    EXTENDED_COMBAT("Extended Combat", "Stay in combat for over 40 seconds and deal 10k damage to the enemy carrier.", GameMode.CAPTURE_THE_FLAG, Specializations.BERSERKER, warlordsPlayer -> {
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(40);
        float totalDamageToCarrier = 0.0f;
        for (WarlordsDamageHealingFinalEvent event : events) {
            if (!event.isHasFlag()) continue;
            if (event.isAttackerInCombat()) {
                totalDamageToCarrier += event.getValue();
                continue;
            }
            return false;
        }
        return totalDamageToCarrier >= 10000.0f;
    }, false),
    SPLIT_SECOND("Split Second", "Prevent over 2k damage dealt to the flag carrier within 1s of the ability activating.", GameMode.CAPTURE_THE_FLAG, Specializations.DEFENDER, warlordsPlayer -> new CooldownFilter<RegularCooldown>((WarlordsPlayer)warlordsPlayer, RegularCooldown.class).filterCooldownFrom((WarlordsPlayer)warlordsPlayer).filter(regularCooldown -> regularCooldown.getStartingTicks() - regularCooldown.getTicksLeft() <= 20).filterCooldownClassAndMapToObjectsOfClass(Intervene.class).anyMatch(intervene -> intervene.getDamagePrevented() >= 2000.0f), false),
    ORBIFICATOR("Orbificator", "Return the flag while being popped from your Undying Army.", GameMode.CAPTURE_THE_FLAG, Specializations.REVENANT, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent lastDamageEvent = warlordsPlayer.getSecondStats().getLastEventAsAttacker();
        if (lastDamageEvent.isDead() && lastDamageEvent.isHasFlag()) {
            return new CooldownFilter<RegularCooldown>((WarlordsPlayer)warlordsPlayer, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(UndyingArmy.class).anyMatch(undyingArmy -> undyingArmy.getPlayersPopped().getOrDefault(warlordsPlayer, false));
        }
        return false;
    }, false),
    REVENGE_BLAST("Revenge Blast", "Kill 3 enemies within 5s of your flag carrier dying. ", GameMode.CAPTURE_THE_FLAG, Specializations.AVENGER, warlordsPlayer -> {
        boolean carrierDeadLast5Seconds = false;
        for (WarlordsPlayer player : PlayerFilter.playingGame(warlordsPlayer.getGame()).teammatesOf((WarlordsPlayer)warlordsPlayer).excluding((WarlordsPlayer)warlordsPlayer).stream().collect(Collectors.toList())) {
            if (!player.getSecondStats().getEventsAsSelfFromLastSecond(5).stream().filter(WarlordsDamageHealingFinalEvent::isHasFlag).anyMatch(WarlordsDamageHealingFinalEvent::isDead)) continue;
            carrierDeadLast5Seconds = true;
            break;
        }
        if (carrierDeadLast5Seconds) {
            return warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(5).stream().filter(WarlordsDamageHealingFinalEvent::isDead).count() >= 3L;
        }
        return false;
    }, false),
    HOUR_OF_RECKONING("Hour of Reckoning", "Kill the enemy carrier while 4 or more allies are affected by your Inspiring Presence.", GameMode.CAPTURE_THE_FLAG, Specializations.CRUSADER, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent lastDamageEvent = warlordsPlayer.getSecondStats().getLastEventAsAttacker();
        if (lastDamageEvent.isDead() && lastDamageEvent.isHasFlag()) {
            return new CooldownFilter<RegularCooldown>((WarlordsPlayer)warlordsPlayer, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(InspiringPresence.class).anyMatch(inspiringPresence -> inspiringPresence.getPlayersEffected().size() >= 4);
        }
        return false;
    }, false),
    TALENT_SHREDDER("Talent Shredder", "Deal 3k damage to the enemy carrier while they have an active shield/damage reduction.", GameMode.CAPTURE_THE_FLAG, Specializations.PROTECTOR, warlordsPlayer -> {
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(3);
        WarlordsPlayer carrier = null;
        int index = -1;
        for (int i = 0; i < events.size(); ++i) {
            WarlordsDamageHealingFinalEvent event = events.get(i);
            if (!event.isHasFlag()) continue;
            if (!event.getPlayerCooldowns().stream().map(WarlordsDamageHealingFinalEvent.CooldownRecord::getAbstractCooldown).filter(RegularCooldown.class::isInstance).map(RegularCooldown.class::cast).anyMatch(regularCooldown -> regularCooldown.getCooldownObject() instanceof ArcaneShield || regularCooldown.getCooldownObject() instanceof IceBarrier || regularCooldown.getCooldownObject() instanceof LastStand)) continue;
            carrier = event.getPlayer();
            index = i;
            break;
        }
        if (carrier != null) {
            int totalDamage = 0;
            for (int i = index; i < events.size(); ++i) {
                WarlordsDamageHealingFinalEvent event = events.get(i);
                if (event.getPlayer() != carrier || !event.isHasFlag()) continue;
                totalDamage = (int)((float)totalDamage + event.getValue());
            }
            return totalDamage >= 3000;
        }
        return false;
    }, false),
    ROADBLOCK("Roadblock?!", "Proc your Capacitor Totem three (or more) times after your carrier passes through the totem.", GameMode.CAPTURE_THE_FLAG, Specializations.THUNDERLORD, warlordsPlayer -> {
        WarlordsDamageHealingFinalEvent lastDamageEvent = warlordsPlayer.getSecondStats().getLastEventAsAttacker();
        return lastDamageEvent.getAttackerCooldowns().stream().map(WarlordsDamageHealingFinalEvent.CooldownRecord::getAbstractCooldown).filter(RegularCooldown.class::isInstance).map(RegularCooldown.class::cast).filter(regularCooldown -> Objects.equals(regularCooldown.getCooldownClass(), CapacitorTotem.class)).map(regularCooldown -> (CapacitorTotem)regularCooldown.getCooldownObject()).anyMatch(capacitorTotem -> capacitorTotem.getNumberOfProcsAfterCarrierPassed() >= 3);
    }, false),
    PERSISTENT_THREAT("Persistent Threat", "Proc soulbinding healing/cooldown reduction 10 times on the enemy carrier within 20 seconds.", GameMode.CAPTURE_THE_FLAG, Specializations.SPIRITGUARD, warlordsPlayer -> {
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(20);
        for (WarlordsDamageHealingFinalEvent event : events) {
            if (!event.isHasFlag()) continue;
            return event.getAttackerCooldowns().stream().map(WarlordsDamageHealingFinalEvent.CooldownRecord::getAbstractCooldown).filter(PersistentCooldown.class::isInstance).map(PersistentCooldown.class::cast).filter(persistentCooldown -> Objects.equals(persistentCooldown.getCooldownClass(), Soulbinding.class)).map(persistentCooldown -> (Soulbinding)persistentCooldown.getCooldownObject()).anyMatch(soulbinding -> soulbinding.getAllProcedPlayers().stream().filter(wp -> wp == event.getPlayer()).count() >= 10L);
        }
        return false;
    }, false),
    WHERE_ARE_YOU_GOING("Where are you going?", "Kill the enemy flag carrier after landing 5 or more abilities on them.", GameMode.CAPTURE_THE_FLAG, Specializations.EARTHWARDEN, warlordsPlayer -> {
        int i;
        List<WarlordsDamageHealingFinalEvent> events = warlordsPlayer.getSecondStats().getEventsAsAttackerFromLastSecond(10);
        int indexCarrier = -1;
        int indexCarrierKilled = -1;
        WarlordsPlayer carrier = null;
        for (i = 0; i < events.size(); ++i) {
            if (!events.get(i).isHasFlag()) continue;
            indexCarrier = i;
            carrier = events.get(i).getPlayer();
            break;
        }
        if (indexCarrier != -1) {
            for (i = 0; i < events.size(); ++i) {
                WarlordsDamageHealingFinalEvent event = events.get(i);
                if (!event.getPlayer().equals(carrier) || !event.isDead()) continue;
                indexCarrierKilled = i;
                break;
            }
        } else {
            return false;
        }
        if (indexCarrierKilled != -1) {
            WarlordsPlayer finalCarrier = carrier;
            int numberOfAbilityAttackers = (int)events.subList(indexCarrier, indexCarrierKilled).stream().filter(warlordsDamageHealingFinalEvent -> warlordsDamageHealingFinalEvent.getPlayer().equals(finalCarrier)).filter(warlordsDamageHealingFinalEvent -> !warlordsDamageHealingFinalEvent.getAbility().isEmpty()).count();
            return numberOfAbilityAttackers >= 5;
        }
        return false;
    }, false);

    public String name;
    public String description;
    public GameMode gameMode;
    public Specializations spec;
    public Predicate<WarlordsPlayer> warlordsPlayerPredicate;
    public boolean checkTeammates;

    private ChallengeAchievements(String name, String description, GameMode gameMode, Specializations spec, Predicate<WarlordsPlayer> warlordsPlayerPredicate, boolean checkTeammates) {
        this.name = name;
        this.description = description;
        this.gameMode = gameMode;
        this.spec = spec;
        this.warlordsPlayerPredicate = warlordsPlayerPredicate;
        this.checkTeammates = checkTeammates;
    }

    public static void checkForAchievement(WarlordsPlayer player, ChallengeAchievements achievement) {
        if (achievement.warlordsPlayerPredicate.test(player)) {
            if (achievement.checkTeammates) {
                ChallengeAchievements.checkTeammatesForSameAchievement(player, achievement);
            } else {
                player.unlockAchievement(achievement);
            }
        }
    }

    public static void checkTeammatesForSameAchievement(WarlordsPlayer player, ChallengeAchievements achievement) {
        player.getGame().warlordsPlayers().filter(warlordsPlayer -> warlordsPlayer.getTeam() == player.getTeam()).filter(warlordsPlayer -> achievement.warlordsPlayerPredicate.test((WarlordsPlayer)warlordsPlayer)).forEachOrdered(warlordsPlayer -> warlordsPlayer.unlockAchievement(achievement));
    }

    @Override
    public void sendAchievementUnlockMessage(Player player) {
        TextComponent message = new TextComponent(ChatColor.GREEN + ">>  Achievement Unlocked: " + ChatColor.GOLD + this.name + ChatColor.GREEN + "  <<");
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(WordWrap.wrapWithNewlineWithColor(this.description, 200, ChatColor.GREEN)).create()));
        ChatUtils.sendMessageToPlayer(player, Collections.singletonList(message), ChatColor.GREEN, true);
    }

    @Override
    public void sendAchievementUnlockMessageToOthers(WarlordsPlayer warlordsPlayer) {
        TextComponent message = new TextComponent(ChatColor.GREEN + ">>  " + ChatColor.AQUA + warlordsPlayer.getName() + ChatColor.GREEN + " unlocked: " + ChatColor.GOLD + this.name + ChatColor.GREEN + "  <<");
        message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(WordWrap.wrapWithNewlineWithColor(this.description, 200, ChatColor.GREEN)).create()));
        warlordsPlayer.getGame().warlordsPlayers().filter(wp -> wp != warlordsPlayer).filter(wp -> wp.getEntity() instanceof Player).map(wp -> (Player)wp.getEntity()).forEachOrdered(player -> ChatUtils.sendMessageToPlayer(player, Collections.singletonList(message), ChatColor.GREEN, true));
    }

    public static class ChallengeAchievementRecord
    extends Achievement.AbstractAchievementRecord<ChallengeAchievements> {
        public ChallengeAchievementRecord() {
        }

        public ChallengeAchievementRecord(ChallengeAchievements achievement) {
            super(achievement);
        }

        public ChallengeAchievementRecord(ChallengeAchievements achievement, Date date) {
            super(achievement, date);
        }

        @Override
        public String getName() {
            return ((ChallengeAchievements)this.getAchievement()).name;
        }

        @Override
        public String getDescription() {
            return ((ChallengeAchievements)this.getAchievement()).description;
        }

        @Override
        public GameMode getGameMode() {
            return ((ChallengeAchievements)this.getAchievement()).gameMode;
        }

        public ChallengeAchievements[] getAchievements() {
            return ChallengeAchievements.values();
        }
    }
}

