/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties.internal;

import com.ebicep.warlords.abilties.AvengersStrike;
import com.ebicep.warlords.abilties.Consecrate;
import com.ebicep.warlords.abilties.CripplingStrike;
import com.ebicep.warlords.abilties.CrusadersStrike;
import com.ebicep.warlords.abilties.HammerOfLight;
import com.ebicep.warlords.abilties.ImpalingStrike;
import com.ebicep.warlords.abilties.JudgementStrike;
import com.ebicep.warlords.abilties.ProtectorsStrike;
import com.ebicep.warlords.abilties.RighteousStrike;
import com.ebicep.warlords.abilties.WoundingStrikeBerserker;
import com.ebicep.warlords.abilties.WoundingStrikeDefender;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public abstract class AbstractStrikeBase
extends AbstractAbility {
    public AbstractStrikeBase(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
    }

    protected abstract void onHit(@Nonnull WarlordsPlayer var1, @Nonnull Player var2, @Nonnull WarlordsPlayer var3);

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        PlayerFilter.entitiesAround(wp, 4.8, 4.8, 4.8).aliveEnemiesOf(wp).closestFirst(wp).requireLineOfSight(wp).lookingAtFirst(wp).first(nearPlayer -> {
            if (Utils.isLookingAt((LivingEntity)player, nearPlayer.getEntity()) && Utils.hasLineOfSight((LivingEntity)player, nearPlayer.getEntity())) {
                this.addTimesUsed();
                AbstractPlayerClass.sendRightClickPacket(player);
                Optional<HammerOfLight> optionalHammer = new CooldownFilter<RegularCooldown>(wp, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(HammerOfLight.class).findAny();
                if (optionalHammer.isPresent()) {
                    wp.subtractEnergy(this.energyCost - (optionalHammer.get().isCrownOfLight() ? 10 : 0));
                } else {
                    wp.subtractEnergy(this.energyCost);
                }
                if (this instanceof AvengersStrike || this instanceof CrusadersStrike || this instanceof ProtectorsStrike) {
                    Utils.playGlobalSound(nearPlayer.getLocation(), "paladin.paladinstrike.activation", 2.0f, 1.0f);
                    this.randomHitEffect((WarlordsPlayer)nearPlayer, 5, 255, 0, 0);
                    ParticleEffect.SPELL.display((float)(Math.random() * 2.0 - 1.0), (float)(Math.random() * 2.0 - 1.0), (float)(Math.random() * 2.0 - 1.0), 1.0f, 4, nearPlayer.getLocation().clone().add(0.0, 1.0, 0.0), 500.0);
                } else if (this instanceof WoundingStrikeBerserker || this instanceof WoundingStrikeDefender || this instanceof CripplingStrike) {
                    Utils.playGlobalSound(nearPlayer.getLocation(), "warrior.mortalstrike.impact", 2.0f, 1.0f);
                    this.randomHitEffect((WarlordsPlayer)nearPlayer, 7, 255, 0, 0);
                } else if (this instanceof JudgementStrike) {
                    Utils.playGlobalSound(nearPlayer.getLocation(), "warrior.revenant.orbsoflife", 2.0f, 1.7f);
                    Utils.playGlobalSound(nearPlayer.getLocation(), "mage.frostbolt.activation", 2.0f, 2.0f);
                    this.randomHitEffect((WarlordsPlayer)nearPlayer, 7, 255, 255, 255);
                } else if (this instanceof RighteousStrike) {
                    Utils.playGlobalSound(nearPlayer.getLocation(), "rogue.vindicatorstrike.activation", 2.0f, 0.7f);
                    Utils.playGlobalSound(nearPlayer.getLocation(), "shaman.earthenspike.impact", 2.0f, 2.0f);
                    this.randomHitEffect((WarlordsPlayer)nearPlayer, 7, 255, 255, 255);
                } else if (this instanceof ImpalingStrike) {
                    Utils.playGlobalSound(nearPlayer.getLocation(), "rogue.apothecarystrike.activation", 2.0f, 0.5f);
                    Utils.playGlobalSound(nearPlayer.getLocation(), "mage.fireball.activation", 2.0f, 1.8f);
                    this.randomHitEffect((WarlordsPlayer)nearPlayer, 7, 100, 255, 100);
                }
                this.onHit(wp, player, (WarlordsPlayer)nearPlayer);
            }
        });
        return true;
    }

    private void randomHitEffect(WarlordsPlayer player, int particleAmount, int red, int green, int blue) {
        for (int i = 0; i < particleAmount; ++i) {
            ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(red, green, blue), player.getLocation().clone().add(Math.random() * 2.0 - 1.0, 1.2 + Math.random() * 2.0 - 1.0, Math.random() * 2.0 - 1.0), 500.0);
        }
    }

    protected boolean standingOnConsecrate(WarlordsPlayer owner, WarlordsPlayer standing) {
        return new CooldownFilter<RegularCooldown>(owner, RegularCooldown.class).filterCooldownClassAndMapToObjectsOfClass(Consecrate.class).anyMatch(consecrate -> consecrate.getLocation().distanceSquared(standing.getLocation()) < (double)(consecrate.getRadius() * consecrate.getRadius()));
    }
}

