/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties.internal;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.IBlockData;
import net.minecraft.server.v1_8_R3.MovingObjectPosition;
import net.minecraft.server.v1_8_R3.Vec3D;
import net.minecraft.server.v1_8_R3.World;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public abstract class AbstractPiercingProjectileBase
extends AbstractAbility {
    protected int playersHit = 0;
    protected int playersHitBySplash = 0;
    protected int directHits = 0;
    protected int numberOfDismounts = 0;
    private final List<PendingHit> PENDING_HITS = new ArrayList<PendingHit>();
    protected final double projectileSpeed;
    protected final int maxTicks;
    protected final double maxDistance;
    protected final boolean hitTeammates;
    protected final float playerHitbox = 0.75f;

    public AbstractPiercingProjectileBase(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier, double projectileSpeed, double maxDistance, boolean hitTeammates) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
        this.projectileSpeed = projectileSpeed;
        this.maxDistance = maxDistance;
        this.maxTicks = (int)(maxDistance / projectileSpeed) + 1;
        this.hitTeammates = hitTeammates;
    }

    @Nullable
    protected abstract String getActivationSound();

    protected abstract float getSoundPitch();

    protected abstract float getSoundVolume();

    @Deprecated
    protected abstract void playEffect(@Nonnull Location var1, int var2);

    protected void playEffect(@Nonnull InternalProjectile projectile) {
        for (InternalProjectileTask task : projectile.tasks) {
            task.run(projectile);
        }
        this.playEffect(projectile.currentLocation, projectile.ticksLived);
    }

    protected abstract boolean shouldEndProjectileOnHit(@Nonnull InternalProjectile var1, Block var2);

    protected abstract boolean shouldEndProjectileOnHit(@Nonnull InternalProjectile var1, WarlordsPlayer var2);

    protected abstract void onNonCancellingHit(@Nonnull InternalProjectile var1, @Nonnull WarlordsPlayer var2, @Nonnull Location var3);

    protected abstract int onHit(@Nonnull InternalProjectile var1, @Nullable WarlordsPlayer var2);

    @Nullable
    protected WarlordsPlayer getFromEntity(Entity e) {
        if (e instanceof Horse) {
            return Warlords.getPlayer(e.getPassenger());
        }
        return Warlords.getPlayer(e);
    }

    protected void updateSpeed(InternalProjectile projectile) {
        this.updateSpeed(projectile.getSpeed(), projectile.getTicksLived());
    }

    @Deprecated
    protected void updateSpeed(Vector speedVector, int ticksLived) {
    }

    double lerp(double a, double b, double target) {
        return a + target * (b - a);
    }

    @Nullable
    protected MovingObjectPosition checkCollisionAndMove(InternalProjectile projectile, Location currentLocation, Vector speed, WarlordsPlayer shooter) {
        Vec3D before = new Vec3D(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ());
        currentLocation.add(speed);
        Vec3D after = new Vec3D(currentLocation.getX(), currentLocation.getY(), currentLocation.getZ());
        int radius = 3;
        PlayerFilter.entitiesInRectangle(currentLocation.getWorld(), Math.min(before.a - (double)radius, after.a - (double)radius), Math.min(before.b - (double)radius, after.b - (double)radius), Math.min(before.c - (double)radius, after.c - (double)radius), Math.max(before.a + (double)radius, after.a + (double)radius), Math.max(before.b + (double)radius, after.b + (double)radius), Math.max(before.c + (double)radius, after.c + (double)radius)).enemiesOf(shooter).filter(e -> true);
        MovingObjectPosition hit = null;
        double hitDistance = 0.0;
        for (Entity entity : currentLocation.getWorld().getEntities()) {
            WarlordsPlayer wp = this.getFromEntity(entity);
            if (wp == null || !this.hitTeammates && !shooter.isEnemyAlive(wp) || !wp.isAlive() || wp == shooter) continue;
            assert (entity instanceof CraftEntity);
            net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB aabb = nmsEntity.getBoundingBox();
            aabb = new AxisAlignedBB(aabb.a - 0.75, aabb.b - 0.75, aabb.c - 0.75, aabb.d + 0.75, aabb.e + 0.75, aabb.f + 0.75);
            MovingObjectPosition mop = aabb.a(after, before);
            if (mop == null) continue;
            mop.entity = nmsEntity;
            double distance = before.distanceSquared(mop.pos);
            if (this.shouldEndProjectileOnHit(projectile, wp)) {
                if (hit != null && !(distance < hitDistance)) continue;
                hitDistance = distance;
                hit = mop;
                continue;
            }
            this.PENDING_HITS.add(new PendingHit(new Location(currentLocation.getWorld(), mop.pos.a, mop.pos.b, mop.pos.c), distance, wp));
        }
        BlockIterator itr = new BlockIterator(currentLocation.getWorld(), new Vector(before.a, before.b, before.c), speed, 0.0, (int)(this.projectileSpeed + 1.0));
        while (itr.hasNext()) {
            Block block = itr.next();
            if (!block.getType().isSolid() || block.getType() == Material.BARRIER || block.getType() == Material.STANDING_BANNER) continue;
            BlockPosition pos = new BlockPosition(block.getX(), block.getY(), block.getZ());
            WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
            IBlockData type = world.getType(pos);
            AxisAlignedBB box = type.getBlock().a((World)world, pos, type);
            MovingObjectPosition mop = box.a(after, before);
            if (mop == null) continue;
            double distance = before.distanceSquared(mop.pos);
            if (!this.shouldEndProjectileOnHit(projectile, block)) continue;
            if (hit != null && !(distance < hitDistance)) break;
            hitDistance = distance;
            hit = mop;
            break;
        }
        if (hit != null) {
            currentLocation.setX(hit.pos.a);
            currentLocation.setY(hit.pos.b);
            currentLocation.setZ(hit.pos.c);
        }
        if (!this.PENDING_HITS.isEmpty()) {
            Collections.sort(this.PENDING_HITS);
            for (PendingHit p : this.PENDING_HITS) {
                if (hit != null && !(hitDistance < p.distance)) break;
                this.onNonCancellingHit(projectile, p.hit, p.loc);
            }
            this.PENDING_HITS.clear();
        }
        return hit;
    }

    protected Location getProjectileStartingLocation(WarlordsPlayer shooter, Location startingLocation) {
        return startingLocation.clone().add(startingLocation.getDirection().multiply(0.2));
    }

    protected Vector getProjectileStartingSpeed(WarlordsPlayer shooter, Location startingLocation) {
        return startingLocation.getDirection().multiply(this.projectileSpeed);
    }

    protected void onSpawn(@Nonnull InternalProjectile projectile) {
        String activationSound = this.getActivationSound();
        float soundVolume = this.getSoundVolume();
        float soundPitch = this.getSoundPitch();
        if (activationSound != null) {
            Utils.playGlobalSound(projectile.getStartingLocation(), activationSound, soundVolume, soundPitch);
        }
    }

    @Override
    public boolean onActivate(WarlordsPlayer shooter, Player player) {
        shooter.subtractEnergy(this.energyCost);
        Location startingLocation = player.getEyeLocation();
        InternalProjectile projectile = new InternalProjectile(shooter, startingLocation);
        this.onSpawn(projectile);
        projectile.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 1L);
        return true;
    }

    public int getDirectHits() {
        return this.directHits;
    }

    private final class PendingHit
    implements Comparable<PendingHit> {
        final Location loc;
        final double distance;
        final WarlordsPlayer hit;

        public PendingHit(Location loc, double distance, WarlordsPlayer hit) {
            this.loc = loc;
            this.distance = distance;
            this.hit = hit;
        }

        @Override
        public int compareTo(PendingHit o) {
            return Double.compare(this.distance, o.distance);
        }
    }

    public static interface InternalProjectileTask {
        public void run(InternalProjectile var1);

        default public void onDestroy(InternalProjectile projectile) {
        }
    }

    public class InternalProjectile
    extends BukkitRunnable {
        private final List<WarlordsPlayer> hit = new ArrayList<WarlordsPlayer>();
        private final List<InternalProjectileTask> tasks = new ArrayList<InternalProjectileTask>();
        private final Location startingLocation;
        private final Location currentLocation;
        private final Vector speed;
        private int ticksLived = 0;
        private final WarlordsPlayer shooter;

        private InternalProjectile(WarlordsPlayer shooter, Location startingLocation) {
            this.currentLocation = AbstractPiercingProjectileBase.this.getProjectileStartingLocation(shooter, startingLocation);
            this.speed = AbstractPiercingProjectileBase.this.getProjectileStartingSpeed(shooter, startingLocation);
            this.shooter = shooter;
            this.startingLocation = this.currentLocation.clone();
        }

        public String toString() {
            return "InternalProjectile{hit=" + this.hit + ", tasks=" + this.tasks + ", startingLocation=" + this.startingLocation + ", currentLocation=" + this.currentLocation + ", speed=" + this.speed + ", ticksLived=" + this.ticksLived + ", shooter=" + this.shooter + '}';
        }

        public synchronized void cancel() throws IllegalStateException {
            super.cancel();
            for (InternalProjectileTask task : this.tasks) {
                task.onDestroy(this);
            }
        }

        public void run() {
            if (!this.shooter.getGame().isFrozen()) {
                AbstractPiercingProjectileBase.this.updateSpeed(this);
                MovingObjectPosition hasCollided = AbstractPiercingProjectileBase.this.checkCollisionAndMove(this, this.currentLocation, this.speed, this.shooter);
                if (hasCollided != null) {
                    int hitBySplash = AbstractPiercingProjectileBase.this.onHit(this, hasCollided.entity == null ? null : AbstractPiercingProjectileBase.this.getFromEntity((Entity)hasCollided.entity.getBukkitEntity()));
                    if (hasCollided.entity != null) {
                        ++AbstractPiercingProjectileBase.this.directHits;
                    }
                    if (hitBySplash > 0) {
                        ++AbstractPiercingProjectileBase.this.playersHit;
                        AbstractPiercingProjectileBase.this.playersHitBySplash += hitBySplash;
                    }
                    this.cancel();
                } else if (this.ticksLived >= AbstractPiercingProjectileBase.this.maxTicks) {
                    this.cancel();
                } else {
                    AbstractPiercingProjectileBase.this.playEffect(this);
                    ++this.ticksLived;
                    if (this.ticksLived > 300) {
                        this.cancel();
                    }
                }
            }
        }

        public int getTicksLived() {
            return this.ticksLived;
        }

        public void setTicksLived(int ticksLived) {
            this.ticksLived = ticksLived;
        }

        public List<WarlordsPlayer> getHit() {
            return this.hit;
        }

        public Location getStartingLocation() {
            return this.startingLocation;
        }

        public Location getCurrentLocation() {
            return this.currentLocation;
        }

        public Vector getSpeed() {
            return this.speed;
        }

        public WarlordsPlayer getShooter() {
            return this.shooter;
        }

        public org.bukkit.World getWorld() {
            return this.currentLocation.getWorld();
        }

        public void addTask(InternalProjectileTask task) {
            this.tasks.add(task);
        }

        public List<InternalProjectileTask> getTasks() {
            return this.tasks;
        }
    }
}

