/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties.internal;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractHolyRadianceBase
extends AbstractAbility {
    protected int playersHealed = 0;
    protected int playersMarked = 0;
    private final int radius;

    public AbstractHolyRadianceBase(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier, int radius) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
        this.radius = radius;
    }

    public abstract boolean chain(WarlordsPlayer var1, Player var2);

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
        wp.subtractEnergy(this.energyCost);
        if (this.chain(wp, player)) {
            ++this.playersMarked;
        }
        for (WarlordsPlayer radianceTarget : PlayerFilter.entitiesAround((Entity)player, (double)this.radius, (double)this.radius, (double)this.radius).aliveTeammatesOfExcludingSelf(wp)) {
            wp.getGame().registerGameTask(new FlyingArmorStand(wp.getLocation(), radianceTarget, wp, 1.1, this.minDamageHeal, this.maxDamageHeal).runTaskTimer((Plugin)Warlords.getInstance(), 1L, 1L));
        }
        player.playSound(player.getLocation(), Sound.ORB_PICKUP, 1.0f, 1.0f);
        Utils.playGlobalSound(player.getLocation(), "paladin.holyradiance.activation", 2.0f, 1.0f);
        Location particleLoc = player.getLocation().add(0.0, 1.2, 0.0);
        ParticleEffect.VILLAGER_HAPPY.display(1.0f, 1.0f, 1.0f, 0.1f, 2, particleLoc, 500.0);
        ParticleEffect.SPELL.display(1.0f, 1.0f, 1.0f, 0.06f, 12, particleLoc, 500.0);
        return true;
    }

    public class FlyingArmorStand
    extends BukkitRunnable {
        private final WarlordsPlayer target;
        private final WarlordsPlayer owner;
        private final double speed;
        private final ArmorStand armorStand;
        private final float minHeal;
        private final float maxHeal;

        public FlyingArmorStand(Location location, WarlordsPlayer target, WarlordsPlayer owner, double speed, float minHeal, float maxHeal) {
            this.armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            this.armorStand.setGravity(false);
            this.armorStand.setVisible(false);
            this.target = target;
            this.speed = speed;
            this.owner = owner;
            this.minHeal = minHeal;
            this.maxHeal = maxHeal;
        }

        public void cancel() {
            super.cancel();
            this.armorStand.remove();
        }

        public void run() {
            if (!this.owner.getGame().isFrozen()) {
                Location armorStandLocation;
                if (this.target.isDead()) {
                    this.cancel();
                    return;
                }
                if (this.target.getWorld() != this.armorStand.getWorld()) {
                    this.cancel();
                    return;
                }
                Location targetLocation = this.target.getLocation();
                double distance = targetLocation.distanceSquared(armorStandLocation = this.armorStand.getLocation());
                if (distance < this.speed * this.speed) {
                    ++AbstractHolyRadianceBase.this.playersHealed;
                    this.target.addHealingInstance(this.owner, AbstractHolyRadianceBase.this.name, this.minHeal, this.maxHeal, AbstractHolyRadianceBase.this.critChance, AbstractHolyRadianceBase.this.critMultiplier, false, false);
                    this.cancel();
                    return;
                }
                targetLocation.subtract(armorStandLocation);
                targetLocation.multiply(Math.max(this.speed * 3.25 / targetLocation.lengthSquared() / 2.0, this.speed / 10.0));
                armorStandLocation.add(targetLocation);
                this.armorStand.teleport(armorStandLocation);
                ParticleEffect.SPELL.display(0.01f, 0.0f, 0.01f, 0.1f, 2, armorStandLocation.add(0.0, 1.75, 0.0), 500.0);
            }
        }
    }
}

