/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties.internal;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.player.WarlordsPlayer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public abstract class AbstractChainBase
extends AbstractAbility {
    protected int playersHit = 0;

    public AbstractChainBase(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        super(name, minDamageHeal, maxDamageHeal, cooldown, energyCost, critChance, critMultiplier);
    }

    protected abstract int getHitCounterAndActivate(WarlordsPlayer var1, Player var2);

    protected abstract void onHit(WarlordsPlayer var1, Player var2, int var3);

    protected abstract ItemStack getChainItem();

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer warlordsPlayer, @Nonnull Player player) {
        int hitCounter = this.getHitCounterAndActivate(warlordsPlayer, player);
        if (hitCounter != 0) {
            this.playersHit += hitCounter;
            AbstractPlayerClass.sendRightClickPacket(player);
            warlordsPlayer.subtractEnergy(this.energyCost);
            this.onHit(warlordsPlayer, player, hitCounter);
            return true;
        }
        return false;
    }

    protected void chain(Location from, Location to) {
        Location location = from.subtract(0.0, 0.5, 0.0);
        location.setDirection(location.toVector().subtract(to.subtract(0.0, 0.5, 0.0).toVector()).multiply(-1));
        this.spawnChain(to, location);
    }

    protected void spawnChain(Location to, Location from) {
        final ArrayList<ArmorStand> chains = new ArrayList<ArmorStand>();
        int maxDistance = (int)Math.round(to.distance(from));
        for (int i = 0; i < maxDistance; ++i) {
            ArmorStand chain = (ArmorStand)from.getWorld().spawn(from, ArmorStand.class);
            chain.setHeadPose(new EulerAngle(from.getDirection().getY() * -1.0, 0.0, 0.0));
            chain.setGravity(false);
            chain.setVisible(false);
            chain.setBasePlate(false);
            chain.setMarker(true);
            chain.setHelmet(this.getChainItem());
            from.add(from.getDirection().multiply(1.1));
            chains.add(chain);
            if (to.distanceSquared(from) < 0.4) break;
        }
        new BukkitRunnable(){

            public void run() {
                if (chains.isEmpty()) {
                    this.cancel();
                }
                for (int i = 0; i < chains.size(); ++i) {
                    ArmorStand armorStand = (ArmorStand)chains.get(i);
                    if (armorStand.getTicksLived() <= 9) continue;
                    armorStand.remove();
                    chains.remove(i);
                    --i;
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 0L);
    }
}

