/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties.internal;

import com.ebicep.warlords.abilties.ArcaneShield;
import com.ebicep.warlords.classes.AbstractPlayerClass;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.java.NumberFormat;
import com.ebicep.warlords.util.java.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractAbility {
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.#");
    protected int timesUsed = 0;
    protected String name;
    protected float minDamageHeal;
    protected float maxDamageHeal;
    protected float currentCooldown;
    protected float cooldown;
    protected int energyCost;
    protected int critChance;
    protected int critMultiplier;
    protected String description;
    protected boolean boosted;
    protected final List<SecondaryAbility> secondaryAbilities = new ArrayList<SecondaryAbility>();

    public AbstractAbility(String name, float minDamageHeal, float maxDamageHeal, float cooldown, int energyCost, int critChance, int critMultiplier) {
        this.name = name;
        this.minDamageHeal = minDamageHeal;
        this.maxDamageHeal = maxDamageHeal;
        this.cooldown = cooldown;
        this.energyCost = energyCost;
        this.critChance = critChance;
        this.critMultiplier = critMultiplier;
        this.boosted = false;
    }

    public abstract void updateDescription(Player var1);

    public abstract List<Pair<String, String>> getAbilityInfo();

    public abstract boolean onActivate(@Nonnull WarlordsPlayer var1, @Nonnull Player var2);

    public void boostSkill(SkillBoosts skillBoost, AbstractPlayerClass abstractPlayerClass) {
        if (!this.boosted) {
            this.boosted = true;
            skillBoost.applyBoost.accept(this);
            if (abstractPlayerClass != null && this instanceof ArcaneShield) {
                ArcaneShield arcaneShield = (ArcaneShield)this;
                arcaneShield.setMaxShieldHealth((int)((float)abstractPlayerClass.getMaxHealth() * ((float)arcaneShield.getShieldPercentage() / 100.0f)));
            }
        }
    }

    public void addTimesUsed() {
        ++this.timesUsed;
    }

    public int getTimesUsed() {
        return this.timesUsed;
    }

    public void setTimesUsed(int timesUsed) {
        this.timesUsed = timesUsed;
    }

    public String getName() {
        return this.name;
    }

    public float getMinDamageHeal() {
        return this.minDamageHeal;
    }

    public void setMinDamageHeal(float minDamageHeal) {
        this.minDamageHeal = minDamageHeal;
    }

    public float getMaxDamageHeal() {
        return this.maxDamageHeal;
    }

    public void setMaxDamageHeal(float maxDamageHeal) {
        this.maxDamageHeal = maxDamageHeal;
    }

    public int getCurrentCooldownItem() {
        return (int)Math.round((double)this.currentCooldown + 0.5);
    }

    public float getCurrentCooldown() {
        return this.currentCooldown;
    }

    public void setCurrentCooldown(float currentCooldown) {
        this.currentCooldown = currentCooldown;
    }

    public void subtractCooldown(float cooldown) {
        if (this.currentCooldown != 0.0f) {
            this.currentCooldown = this.currentCooldown - cooldown < 0.0f ? 0.0f : (this.currentCooldown -= cooldown);
        }
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(float cooldown) {
        this.cooldown = cooldown;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public void setEnergyCost(int energyCost) {
        this.energyCost = energyCost;
    }

    public int getCritChance() {
        return this.critChance;
    }

    public void setCritChance(int critChance) {
        this.critChance = critChance;
    }

    public int getCritMultiplier() {
        return this.critMultiplier;
    }

    public void setCritMultiplier(int critMultiplier) {
        this.critMultiplier = critMultiplier;
    }

    public String getDescription() {
        return this.description;
    }

    public List<SecondaryAbility> getSecondaryAbilities() {
        return this.secondaryAbilities;
    }

    public void addSecondaryAbility(Runnable runnable, boolean infiniteUses, Predicate<SecondaryAbility> shouldRemove) {
        this.secondaryAbilities.add(new SecondaryAbility(runnable, infiniteUses, shouldRemove));
    }

    public void runSecondAbilities() {
        for (int i = 0; i < this.secondaryAbilities.size(); ++i) {
            SecondaryAbility secondaryAbility = this.secondaryAbilities.get(i);
            secondaryAbility.getRunnable().run();
            if (secondaryAbility.isHasInfiniteUses()) continue;
            this.secondaryAbilities.remove(i);
            --i;
        }
    }

    public void checkSecondaryAbilities() {
        this.secondaryAbilities.removeIf(secondaryAbility -> secondaryAbility.getShouldRemove().test((SecondaryAbility)secondaryAbility));
    }

    public ItemStack getItem(ItemStack baseItem) {
        return new ItemBuilder(baseItem).name(ChatColor.GOLD + this.getName()).lore(this.getCooldown() == 0.0f ? null : ChatColor.GRAY + "Cooldown: " + ChatColor.AQUA + NumberFormat.formatOptionalHundredths(this.getCooldown()) + " seconds", this.getEnergyCost() == 0 ? null : ChatColor.GRAY + "Energy Cost: " + ChatColor.YELLOW + this.getEnergyCost(), this.getCritChance() == 0 || this.getCritChance() == -1 || this.getCritMultiplier() == 100 ? null : ChatColor.GRAY + "Crit Chance: " + ChatColor.RED + this.getCritChance() + "%\n" + ChatColor.GRAY + "Crit Multiplier: " + ChatColor.RED + this.getCritMultiplier() + "%", "", this.getDescription()).unbreakable().flags(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE).get();
    }

    public String format(double input) {
        return decimalFormat.format(input);
    }

    public void runEverySecond() {
    }

    static {
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
    }

    public static class SecondaryAbility {
        private final Runnable runnable;
        private final boolean hasInfiniteUses;
        public final Predicate<SecondaryAbility> shouldRemove;

        public SecondaryAbility(Runnable runnable, boolean hasInfiniteUses, Predicate<SecondaryAbility> shouldRemove) {
            this.runnable = runnable;
            this.hasInfiniteUses = hasInfiniteUses;
            this.shouldRemove = shouldRemove;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public boolean isHasInfiniteUses() {
            return this.hasInfiniteUses;
        }

        public Predicate<SecondaryAbility> getShouldRemove() {
            return this.shouldRemove;
        }
    }
}

