/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.WoundingStrikeDefender;
import com.ebicep.warlords.abilties.internal.AbstractStrikeBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class WoundingStrikeBerserker
extends AbstractStrikeBase {
    public WoundingStrikeBerserker() {
        super("Wounding Strike", 497.0f, 632.0f, 0.0f, 100, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Strike the targeted enemy player,\n\u00a77causing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77and \u00a7cwounding \u00a77them for \u00a763 \u00a77seconds.\n\u00a77A wounded player receives \u00a7c40% \u00a77less\n\u00a77healing for the duration of the effect.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Players Struck", "" + this.timesUsed));
        return info;
    }

    @Override
    protected void onHit(@Nonnull WarlordsPlayer wp, @Nonnull Player player, @Nonnull WarlordsPlayer nearPlayer) {
        nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
        if (!nearPlayer.getCooldownManager().hasCooldown(WoundingStrikeBerserker.class) && !nearPlayer.getCooldownManager().hasCooldown(WoundingStrikeDefender.class)) {
            nearPlayer.sendMessage(ChatColor.GRAY + "You are " + ChatColor.RED + "wounded" + ChatColor.GRAY + ".");
        }
        nearPlayer.getCooldownManager().removeCooldown(WoundingStrikeBerserker.class);
        nearPlayer.getCooldownManager().removeCooldown(WoundingStrikeDefender.class);
        nearPlayer.getCooldownManager().addCooldown(new RegularCooldown<WoundingStrikeBerserker>(this.name, "WND", WoundingStrikeBerserker.class, new WoundingStrikeBerserker(), wp, CooldownTypes.DEBUFF, cooldownManager -> {
            if (new CooldownFilter<RegularCooldown>((CooldownManager)cooldownManager, RegularCooldown.class).filterNameActionBar("WND").stream().count() == 1L) {
                nearPlayer.sendMessage(ChatColor.GRAY + "You are no longer " + ChatColor.RED + "wounded" + ChatColor.GRAY + ".");
            }
        }, 60){

            @Override
            public boolean isHealing() {
                return true;
            }

            @Override
            public float doBeforeHealFromSelf(WarlordsDamageHealingEvent event, float currentHealValue) {
                return currentHealValue * 0.6f;
            }
        });
    }
}

