/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.TextCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WonderTrap
extends AbstractAbility {
    public WonderTrap() {
        super("Wonder Trap", 375.0f, 454.0f, 10.0f, 40, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "PLACEHOLDER";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        return null;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        WonderTrap tempTrap = new WonderTrap();
        Utils.playGlobalSound(player.getLocation(), "rogue.hearttoheart.activation", 2.0f, 0.6f);
        final Trap trap = new Trap(wp.getLocation(), wp, 200, 40, 3.0);
        trap.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 0L);
        final TextCooldown<WonderTrap> textCooldown = new TextCooldown<WonderTrap>("Wonder Trap", "TRAP", WonderTrap.class, tempTrap, wp, CooldownTypes.ABILITY, cooldownManager -> {}, "2");
        wp.getCooldownManager().addCooldown(textCooldown);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                switch (this.counter++) {
                    case 1: {
                        textCooldown.setText("1");
                        break;
                    }
                    case 2: {
                        textCooldown.setText("READY");
                        trap.setCanEndEarly(true);
                        break;
                    }
                    case 10: {
                        textCooldown.setRemove(true);
                        trap.cancel();
                        this.cancel();
                    }
                }
                if (this.counter > 2 && wp.isSneaking() && trap.isCanEndEarly()) {
                    trap.cancel();
                    this.cancel();
                    textCooldown.setRemove(true);
                }
            }
        }.runTaskTimer((Plugin)Warlords.getInstance(), 0L, 20L);
        return true;
    }

    private class Trap
    extends BukkitRunnable {
        private final WarlordsPlayer trapOwner;
        private int timeToLive;
        private int trapArmTime;
        private final double trapRadius;
        private final ArmorStand trapStand;
        private boolean canEndEarly = false;

        public Trap(Location location, WarlordsPlayer trapOwner, int timeToLive, int trapArmTime, double trapRadius) {
            this.trapOwner = trapOwner;
            this.timeToLive = timeToLive;
            this.trapArmTime = trapArmTime;
            this.trapRadius = trapRadius;
            this.trapStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            this.trapStand.setHelmet(new ItemStack(Material.STONE));
            this.trapStand.setGravity(false);
            this.trapStand.setVisible(false);
            this.trapStand.getLocation().add(0.0, -2.0, 0.0);
        }

        public void cancel() {
            super.cancel();
            this.trapStand.remove();
        }

        public void run() {
            --this.timeToLive;
            --this.trapArmTime;
            if (this.trapOwner.isSneaking() && this.canEndEarly) {
                Utils.playGlobalSound(this.trapStand.getLocation(), "rogue.wondertrap.explosion", 2.0f, 1.75f);
                EffectUtils.playStarAnimation(this.trapStand.getLocation().add(0.0, -2.0, 0.0), 3.0f, ParticleEffect.FIREWORKS_SPARK);
                PlayerFilter.entitiesAround((Entity)this.trapStand, this.trapRadius, this.trapRadius, this.trapRadius).aliveEnemiesOf(this.trapOwner).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)trapTarget -> {
                    trapTarget.addDamageInstance(this.trapOwner, WonderTrap.this.name, WonderTrap.this.minDamageHeal, WonderTrap.this.maxDamageHeal, WonderTrap.this.critChance, WonderTrap.this.critMultiplier, false);
                    WonderTrap tempTrap = new WonderTrap();
                    trapTarget.getCooldownManager().addRegularCooldown("KB Increase", "KB", WonderTrap.class, tempTrap, this.trapOwner, CooldownTypes.DEBUFF, cooldownManager -> {}, 600, new TriConsumer[0]);
                }));
                this.cancel();
            }
            if (this.timeToLive <= 0) {
                this.cancel();
            }
        }

        public boolean isCanEndEarly() {
            return this.canEndEarly;
        }

        public void setCanEndEarly(boolean canEndEarly) {
            this.canEndEarly = canEndEarly;
        }
    }
}

