/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.SkillBoosts;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Windfury
extends AbstractAbility {
    protected int timesProcd = 0;
    private int procChance = 35;
    private final int duration = 8;

    public Windfury() {
        super("Windfury Weapon", 0.0f, 0.0f, 15.66f, 30, 25, 200);
    }

    @Override
    public void updateDescription(Player player) {
        int weaponDamage = this.procChance == 35 ? 135 : 155;
        this.description = "\u00a77Imbue your weapon with the power\n\u00a77of the wind, causing each of your\n\u00a77melee attacks to have a \u00a7e" + this.procChance + "% \u00a77chance\n\u00a77to hit \u00a7e2 \u00a77additional times for \u00a7c" + weaponDamage + "%\n\u00a77weapon damage. The first melee hit is\n\u00a77guaranteed to activate Windfury. Lasts \u00a76" + 8 + "\n\u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Proc'd", "" + this.timesProcd));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "shaman.windfuryweapon.activation", 2.0f, 1.0f);
        Windfury tempWindfury = new Windfury();
        final boolean[] firstProc = new boolean[]{true};
        wp.getCooldownManager().addCooldown(new RegularCooldown<Windfury>(this.name, "FURY", Windfury.class, tempWindfury, wp, CooldownTypes.ABILITY, cooldownManager -> {}, 160, new TriConsumer[]{(cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                ParticleEffect.CRIT.display(0.2f, 0.0f, 0.2f, 0.1f, 3, wp.getLocation().add(0.0, 1.2, 0.0), 500.0);
            }
        }}){

            @Override
            public void onEndFromAttacker(WarlordsDamageHealingEvent event, float currentDamageValue, boolean isCrit) {
                if (event.getAbility().isEmpty()) {
                    final WarlordsPlayer victim = event.getPlayer();
                    final WarlordsPlayer attacker = event.getAttacker();
                    final float min2 = event.getMin();
                    final float max = event.getMax();
                    int windfuryActivate = (int)(Math.random() * 100.0);
                    if (firstProc[0]) {
                        firstProc[0] = false;
                        windfuryActivate = 0;
                    }
                    if (windfuryActivate < Windfury.this.procChance) {
                        ++Windfury.this.timesProcd;
                        new BukkitRunnable(){
                            int counter = 0;

                            public void run() {
                                Utils.playGlobalSound(victim.getLocation(), "shaman.windfuryweapon.impact", 2.0f, 1.0f);
                                if (Warlords.getPlayerSettings(attacker.getUuid()).getSkillBoostForClass() == SkillBoosts.WINDFURY_WEAPON) {
                                    victim.addDamageInstance(attacker, name, min2 * 1.35f * 1.2f, max * 1.35f * 1.2f, Windfury.this.critChance, Windfury.this.critMultiplier, false);
                                } else {
                                    victim.addDamageInstance(attacker, name, min2 * 1.35f, max * 1.35f, Windfury.this.critChance, Windfury.this.critMultiplier, false);
                                }
                                ++this.counter;
                                if (this.counter == 2) {
                                    this.cancel();
                                }
                            }
                        }.runTaskTimer((Plugin)Warlords.getInstance(), 3L, 3L);
                    }
                }
            }
        });
        return true;
    }

    public int getProcChance() {
        return this.procChance;
    }

    public void setProcChance(int procChance) {
        this.procChance = procChance;
    }
}

