/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.abilties.internal.Overheal;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.bukkit.LocationBuilder;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class WaterBreath
extends AbstractAbility {
    protected int playersHealed = 0;
    protected int debuffsRemoved = 0;

    public WaterBreath() {
        super("Water Breath", 528.0f, 723.0f, 6.3f, 60, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Breathe water in a cone in front of you,\n\u00a77knocking back enemies, cleansing all \u00a7ede-buffs\n\u00a77and restoring \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health to\n\u00a77yourself and all allies hit.\n\n\u00a77Water Breath can overheal allies for up to\n\u00a7a10% \u00a77of their max health as bonus health\n\u00a77for \u00a76" + 15 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        info.add(new Pair<String, String>("Debuffs Removed", "" + this.debuffsRemoved));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "mage.waterbreath.activation", 2.0f, 1.0f);
        ParticleEffect.HEART.display(0.6f, 0.6f, 0.6f, 1.0f, 2, player.getLocation().add(0.0, 0.7, 0.0), 500.0);
        final Location playerLoc = new LocationBuilder(player.getLocation()).pitch(0.0f).add(0.0, 1.7, 0.0);
        new GameRunnable(wp.getGame()){
            int animationTimer;
            final Matrix4d center;
            {
                super(game);
                this.animationTimer = 0;
                this.center = new Matrix4d(playerLoc);
            }

            @Override
            public void run() {
                this.playEffect();
                this.playEffect();
            }

            public void playEffect() {
                if (this.animationTimer > 12) {
                    this.cancel();
                }
                for (int i = 0; i < 4; ++i) {
                    double angle = Math.toRadians(i * 90) + (double)this.animationTimer * 0.15;
                    double width = (double)this.animationTimer * 0.3;
                    ParticleEffect.DRIP_WATER.display(0.0f, 0.0f, 0.0f, 0.0f, 1, this.center.translateVector(wp.getWorld(), (double)this.animationTimer / 2.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                    ParticleEffect.ENCHANTMENT_TABLE.display(0.0f, 0.0f, 0.0f, 0.0f, 1, this.center.translateVector(wp.getWorld(), (double)this.animationTimer / 2.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                    ParticleEffect.VILLAGER_HAPPY.display(0.0f, 0.0f, 0.0f, 0.0f, 1, this.center.translateVector(wp.getWorld(), (double)this.animationTimer / 2.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                }
                ++this.animationTimer;
            }
        }.runTaskTimer(0L, 1L);
        this.debuffsRemoved += wp.getCooldownManager().removeDebuffCooldowns();
        wp.getSpeed().removeSlownessModifiers();
        wp.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
        LocationBuilder hitbox = new LocationBuilder(player.getLocation()).pitch(0.0f).backward(1.0f);
        Vector viewDirection = playerLoc.getDirection();
        for (WarlordsPlayer breathTarget : PlayerFilter.entitiesAroundRectangle(playerLoc, 7.5, 10.0, 7.5).excluding(wp)) {
            Vector direction = breathTarget.getLocation().subtract((Location)hitbox).toVector().normalize();
            if (!(viewDirection.dot(direction) > 0.68)) continue;
            if (wp.isTeammateAlive(breathTarget)) {
                ++this.playersHealed;
                this.debuffsRemoved += breathTarget.getCooldownManager().removeDebuffCooldowns();
                breathTarget.getSpeed().removeSlownessModifiers();
                breathTarget.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
                breathTarget.getCooldownManager().removeCooldownByObject(Overheal.OVERHEAL_MARKER);
                breathTarget.getCooldownManager().addRegularCooldown("Overheal", "OVERHEAL", Overheal.class, Overheal.OVERHEAL_MARKER, wp, CooldownTypes.BUFF, cooldownManager -> {}, 300, new TriConsumer[0]);
                continue;
            }
            Location loc = breathTarget.getLocation();
            Vector v = player.getLocation().toVector().subtract(loc.toVector()).normalize().multiply(-1.1).setY(0.2);
            breathTarget.setVelocity(v, false);
        }
        return true;
    }
}

