/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractPiercingProjectileBase;
import com.ebicep.warlords.abilties.internal.AbstractProjectileBase;
import com.ebicep.warlords.abilties.internal.Overheal;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class WaterBolt
extends AbstractProjectileBase {
    private int teammatesHit = 0;
    private int enemiesHit = 0;
    private static final int MAX_FULL_DAMAGE_DISTANCE = 40;
    private static final double DIRECT_HIT_MULTIPLIER = 1.15;
    private static final float HITBOX = 4.0f;

    public WaterBolt() {
        super("Water Bolt", 315.0f, 434.0f, 0.0f, 80, 20, 175, 2.0, 300.0, true);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Shoot a bolt of water that will burst\n\u00a77for \u00a7c231 \u00a77- \u00a7c299 \u00a77damage and restore\n\u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health to allies. A\n\u00a77direct hit will cause \u00a7a15% \u00a77increased\n\u00a77damage or healing for the target hit.\n\n\u00a77Has an optimal range of \u00a7e" + 40 + " \u00a77blocks.\n\n\u00a77Water Bolt can overheal allies for up to\n\u00a7a10% \u00a77of their max health as bonus health\n\u00a77for \u00a76" + 15 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Shots Fired", "" + this.timesUsed));
        info.add(new Pair<String, String>("Direct Hits", "" + this.directHits));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Teammates Hit", "" + this.teammatesHit));
        info.add(new Pair<String, String>("Enemies Hit", "" + this.enemiesHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected String getActivationSound() {
        return "mage.waterbolt.activation";
    }

    @Override
    protected float getSoundPitch() {
        return 1.0f;
    }

    @Override
    protected float getSoundVolume() {
        return 2.0f;
    }

    @Override
    protected void playEffect(@Nonnull Location currentLocation, int animationTimer) {
        ParticleEffect.DRIP_WATER.display(0.3f, 0.3f, 0.3f, 0.1f, 2, currentLocation, 500.0);
        ParticleEffect.ENCHANTMENT_TABLE.display(0.0f, 0.0f, 0.0f, 0.1f, 1, currentLocation, 500.0);
        ParticleEffect.VILLAGER_HAPPY.display(0.0f, 0.0f, 0.0f, 0.1f, 1, currentLocation, 500.0);
        ParticleEffect.CLOUD.display(0.0f, 0.0f, 0.0f, 0.0f, 1, currentLocation, 500.0);
    }

    @Override
    protected void onSpawn(@Nonnull AbstractPiercingProjectileBase.InternalProjectile projectile) {
        super.onSpawn(projectile);
        this.playEffect(projectile);
    }

    @Override
    protected int onHit(@Nonnull AbstractPiercingProjectileBase.InternalProjectile projectile, @Nullable WarlordsPlayer hit) {
        double toReduceBy;
        WarlordsPlayer shooter = projectile.getShooter();
        Location startingLocation = projectile.getStartingLocation();
        Location currentLocation = projectile.getCurrentLocation();
        ParticleEffect.HEART.display(1.0f, 1.0f, 1.0f, 0.2f, 3, currentLocation, 500.0);
        ParticleEffect.VILLAGER_HAPPY.display(1.0f, 1.0f, 1.0f, 0.2f, 5, currentLocation, 500.0);
        Utils.playGlobalSound(currentLocation, "mage.waterbolt.impact", 2.0f, 1.0f);
        double distanceSquared = currentLocation.distanceSquared(startingLocation);
        double d = toReduceBy = 1600.0 > distanceSquared ? 1.0 : 1.0 - (Math.sqrt(distanceSquared) - 40.0) / 75.0;
        if (toReduceBy < 0.2) {
            toReduceBy = 0.2;
        }
        if (hit != null) {
            if (hit.isTeammate(shooter)) {
                ++this.teammatesHit;
                hit.addHealingInstance(shooter, this.name, (float)((double)this.minDamageHeal * 1.15 * toReduceBy), (float)((double)this.maxDamageHeal * 1.15 * toReduceBy), this.critChance, this.critMultiplier, false, false);
                if (hit != shooter) {
                    hit.getCooldownManager().removeCooldownByObject(Overheal.OVERHEAL_MARKER);
                    hit.getCooldownManager().addRegularCooldown("Overheal", "OVERHEAL", Overheal.class, Overheal.OVERHEAL_MARKER, shooter, CooldownTypes.BUFF, cooldownManager -> {}, 300, new TriConsumer[0]);
                }
            } else {
                ++this.enemiesHit;
                if (hit.onHorse()) {
                    ++this.numberOfDismounts;
                }
                hit.addDamageInstance(shooter, this.name, (float)(265.65 * toReduceBy), (float)(343.84999999999997 * toReduceBy), this.critChance, this.critMultiplier, false);
            }
        }
        int playersHit = 0;
        for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(currentLocation, 4.0, 4.0, 4.0).excluding(hit).isAlive()) {
            ++playersHit;
            if (nearEntity.isTeammate(shooter)) {
                ++this.teammatesHit;
                nearEntity.addHealingInstance(shooter, this.name, (float)((double)this.minDamageHeal * toReduceBy), (float)((double)this.maxDamageHeal * toReduceBy), this.critChance, this.critMultiplier, false, false);
                if (nearEntity == shooter) continue;
                nearEntity.getCooldownManager().removeCooldownByObject(Overheal.OVERHEAL_MARKER);
                nearEntity.getCooldownManager().addRegularCooldown("Overheal", "OVERHEAL", Overheal.class, Overheal.OVERHEAL_MARKER, shooter, CooldownTypes.BUFF, cooldownManager -> {}, 300, new TriConsumer[0]);
                continue;
            }
            ++this.enemiesHit;
            if (nearEntity.onHorse()) {
                ++this.numberOfDismounts;
            }
            nearEntity.addDamageInstance(shooter, this.name, (float)(231.0 * toReduceBy), (float)(299.0 * toReduceBy), this.critChance, this.critMultiplier, false);
        }
        return playersHit;
    }
}

