/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.ImpalingStrike;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.FallingBlockWaveEffect;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VitalityLiquor
extends AbstractAbility {
    protected int numberOfAdditionalWaves = 0;
    private final int acuRange = 8;
    private final int duration = 3;
    private float minWaveHealing = 268.0f;
    private float maxWaveHealing = 324.0f;

    public VitalityLiquor() {
        super("Vitality Liquor", 359.0f, 485.0f, 14.0f, 30, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Discharge a shockwave of special potions\n\u00a77around you, healing allies in the range for\n\u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health.\n\n\u00a77Each enemy afflicted with your \u00a7aLEECH \u00a77effect\n\u00a77within the range will cause the enemy to\n\u00a77discharge an additional shockwave of vitality\n\u00a77that heals \u00a7e2 \u00a77nearby allies for \u00a7a" + this.format(this.minWaveHealing) + " \u00a77- \u00a7a" + this.format(this.maxWaveHealing) + " \u00a77health\n\u00a77and increase their energy regeneration by\n\u00a7e15 \u00a77for \u00a76" + 3 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Number of Additional Waves", "" + this.numberOfAdditionalWaves));
        return info;
    }

    @Override
    public boolean onActivate(final @Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), Sound.GLASS, 2.0f, 0.1f);
        Utils.playGlobalSound(player.getLocation(), Sound.BLAZE_DEATH, 2.0f, 0.7f);
        new FallingBlockWaveEffect(player.getLocation(), 7.0, 1.0, Material.SAPLING, 2).play();
        final VitalityLiquor tempVitalityLiquor = new VitalityLiquor();
        wp.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
        for (WarlordsPlayer acuTarget : PlayerFilter.entitiesAround((Entity)player, 8.0, 8.0, 8.0).aliveTeammatesOfExcludingSelf(wp)) {
            acuTarget.addHealingInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false, false);
        }
        for (final WarlordsPlayer enemyTarget : PlayerFilter.entitiesAround((Entity)player, 8.0, 8.0, 8.0).aliveEnemiesOf(wp)) {
            new CooldownFilter<RegularCooldown>(enemyTarget, RegularCooldown.class).filterCooldownClass(ImpalingStrike.class).filterCooldownFrom(wp).findAny().ifPresent(regularCooldown -> {
                Utils.playGlobalSound(enemyTarget.getLocation(), Sound.GLASS, 2.0f, 0.6f);
                FireWorkEffectPlayer.playFirework(enemyTarget.getLocation(), FireworkEffect.builder().withColor(Color.ORANGE).with(FireworkEffect.Type.STAR).build());
                new GameRunnable(wp.getGame()){

                    @Override
                    public void run() {
                        for (WarlordsPlayer allyTarget : PlayerFilter.entitiesAround(enemyTarget, 6.0, 6.0, 6.0).aliveTeammatesOf(wp).closestFirst(enemyTarget).limit(2L)) {
                            ++VitalityLiquor.this.numberOfAdditionalWaves;
                            allyTarget.addHealingInstance(wp, VitalityLiquor.this.name, VitalityLiquor.this.minWaveHealing, VitalityLiquor.this.maxWaveHealing, VitalityLiquor.this.critChance, VitalityLiquor.this.critMultiplier, false, false);
                            allyTarget.getCooldownManager().removeCooldown(VitalityLiquor.class);
                            allyTarget.getCooldownManager().addRegularCooldown("Vitality Liquor", "VITAL", VitalityLiquor.class, tempVitalityLiquor, wp, CooldownTypes.BUFF, cooldownManager -> {}, 60, new TriConsumer[0]);
                        }
                    }
                }.runTaskLater(5L);
            });
        }
        return true;
    }

    public float getMinWaveHealing() {
        return this.minWaveHealing;
    }

    public void setMinWaveHealing(float minWaveHealing) {
        this.minWaveHealing = minWaveHealing;
    }

    public float getMaxWaveHealing() {
        return this.maxWaveHealing;
    }

    public void setMaxWaveHealing(float maxWaveHealing) {
        this.maxWaveHealing = maxWaveHealing;
    }
}

