/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.java.TriConsumer;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Vindicate
extends AbstractAbility {
    protected int debuffsRemovedOnCast = 0;
    private final int radius = 8;
    private final int vindicateDuration = 12;
    private final int vindicateSelfDuration = 8;
    private float vindicateDamageReduction = 30.0f;

    public Vindicate() {
        super("Vindicate", 0.0f, 0.0f, 55.0f, 25, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77All allies within an \u00a7e8 \u00a77block radius gain the\n\u00a77status \u00a76VIND \u00a77which clears all de-buffs. In\n\u00a77addition, the status \u00a76VIND \u00a77prevents allies from being\n\u00a77affected by de-buffs and grants \u00a7650% \u00a77knockback\n\u00a77resistance for \u00a7612 \u00a77seconds. You gain \u00a7e" + this.format(this.vindicateDamageReduction) + "%\n\u00a77damage reduction for \u00a76" + 8 + " \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Debuffs Removed On Cast", "" + this.debuffsRemovedOnCast));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "rogue.vindicate.activation", 2.0f, 0.7f);
        Utils.playGlobalSound(player.getLocation(), "shaman.capacitortotem.pulse", 2.0f, 0.7f);
        new CircleEffect(wp.getGame(), wp.getTeam(), player.getLocation(), 8.0, new CircumferenceEffect(ParticleEffect.SPELL, ParticleEffect.REDSTONE).particlesPerCircumference(2.0)).playEffects();
        EffectUtils.playHelixAnimation(player, 8.0, 230, 130, 5);
        Vindicate tempVindicate = new Vindicate();
        for (WarlordsPlayer vindicateTarget : PlayerFilter.entitiesAround(wp, 8.0, 8.0, 8.0).aliveTeammatesOf(wp).closestFirst(wp)) {
            if (vindicateTarget != wp) {
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your Vindicate is now protecting " + ChatColor.YELLOW + vindicateTarget.getName() + ChatColor.GRAY + "!");
                vindicateTarget.sendMessage(WarlordsPlayer.RECEIVE_ARROW_GREEN + " " + ChatColor.GRAY + wp.getName() + "'s" + ChatColor.YELLOW + " Vindicate" + ChatColor.GRAY + " is now protecting you from de-buffs for " + ChatColor.GOLD + 12 + ChatColor.GRAY + " seconds!");
            }
            vindicateTarget.getSpeed().removeSlownessModifiers();
            this.debuffsRemovedOnCast += vindicateTarget.getCooldownManager().removeDebuffCooldowns();
            vindicateTarget.getCooldownManager().removeCooldownByName("Vindicate Debuff Immunity");
            vindicateTarget.getCooldownManager().addRegularCooldown("Vindicate Debuff Immunity", "VIND", Vindicate.class, tempVindicate, wp, CooldownTypes.BUFF, cooldownManager -> {}, 240, new TriConsumer[0]);
        }
        wp.getCooldownManager().addCooldown(new RegularCooldown<Vindicate>("Vindicate Resistance", "VIND RESIST", Vindicate.class, tempVindicate, wp, CooldownTypes.BUFF, cooldownManager -> {}, 160){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                return currentDamageValue * Vindicate.this.getVindicateDamageReduction();
            }
        });
        return true;
    }

    public float getVindicateDamageReduction() {
        return (100.0f - this.vindicateDamageReduction) / 100.0f;
    }

    public void setVindicateDamageReduction(int vindicateDamageReduction) {
        this.vindicateDamageReduction = vindicateDamageReduction;
    }
}

