/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.bukkit.ItemBuilder;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UndyingArmy
extends AbstractAbility {
    public static final ItemStack BONE = new ItemBuilder(Material.BONE).name(ChatColor.RED + "Instant Kill").lore("\u00a77Right-click this item to die\n\u00a77instantly instead of waiting for\n\u00a77the decay.").get();
    private final int radius = 15;
    private final HashMap<WarlordsPlayer, Boolean> playersPopped = new HashMap();
    protected int playersArmied = 0;
    private int duration = 10;
    private int maxArmyAllies = 6;

    public UndyingArmy() {
        super("Undying Army", 0.0f, 0.0f, 62.64f, 60, 0, 0);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77You may chain up to \u00a7e" + this.maxArmyAllies + " \u00a77allies in a \u00a7e" + 15 + "\n\u00a77block radius to heal them for \u00a7a100 \u00a77+\n\u00a77\u00a7a3.5% \u00a77of their missing health every second.\nLasts \u00a76" + this.duration + " \u00a77seconds.\n\n\u00a77Chained allies that take fatal damage\n\u00a77will be revived with \u00a7a100% \u00a77of their max health\n\u00a77and \u00a7e100% \u00a77max energy. Revived allies rapidly\n\u00a77take \u00a7c10% \u00a77of their max health as damage every\n\u00a77second.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Armied", "" + this.playersArmied));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), Sound.ZOMBIE_IDLE, 2.0f, 0.3f);
        Utils.playGlobalSound(player.getLocation(), Sound.AMBIENCE_THUNDER, 2.0f, 0.9f);
        Location loc = player.getEyeLocation();
        loc.setPitch(0.0f);
        loc.setYaw(0.0f);
        Matrix4d matrix = new Matrix4d();
        for (int i = 0; i < 9; ++i) {
            double width;
            double angle;
            int c;
            loc.setYaw(loc.getYaw() + 40.0f);
            matrix.updateFromLocation(loc);
            for (c = 0; c < 30; ++c) {
                angle = (double)c / 30.0 * Math.PI * 2.0;
                width = 1.5;
                ParticleEffect.ENCHANTMENT_TABLE.display(0.0f, 0.1f, 0.0f, 0.0f, 1, matrix.translateVector(player.getWorld(), 15.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
            }
            for (c = 0; c < 15; ++c) {
                angle = (double)c / 15.0 * Math.PI * 2.0;
                width = 0.6;
                ParticleEffect.SPELL.display(0.0f, 0.0f, 0.0f, 0.0f, 1, matrix.translateVector(player.getWorld(), 15.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
            }
        }
        new CircleEffect(wp.getGame(), wp.getTeam(), player.getLocation(), 15.0, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE).particlesPerCircumference(2.0)).playEffects();
        UndyingArmy tempUndyingArmy = new UndyingArmy();
        int numberOfPlayersWithArmy = 0;
        for (WarlordsPlayer teammate : PlayerFilter.entitiesAround(wp, 15.0, 15.0, 15.0).aliveTeammatesOf(wp).closestFirst(wp)) {
            tempUndyingArmy.getPlayersPopped().put(teammate, false);
            if (teammate != wp) {
                ++this.playersArmied;
                wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " Your " + ChatColor.YELLOW + "Undying Army" + ChatColor.GRAY + " is now protecting " + teammate.getName() + ChatColor.GRAY + ".");
                teammate.sendMessage(WarlordsPlayer.RECEIVE_ARROW_GREEN + ChatColor.GRAY + " " + ChatColor.GRAY + wp.getName() + "'s " + ChatColor.YELLOW + "Undying Army" + ChatColor.GRAY + " is now protecting you for " + ChatColor.GOLD + this.duration + ChatColor.GRAY + " seconds.");
            }
            teammate.getCooldownManager().addRegularCooldown(this.name, "ARMY", UndyingArmy.class, tempUndyingArmy, wp, CooldownTypes.ABILITY, cooldownManager -> {}, this.duration * 20, (cooldown, ticksLeft, counter) -> {
                if (counter % 20 == 0 && !((UndyingArmy)cooldown.getCooldownObject()).isArmyDead(teammate)) {
                    float healAmount = 100.0f + (float)(teammate.getMaxHealth() - teammate.getHealth()) * 0.035f;
                    teammate.addHealingInstance(wp, this.name, healAmount, healAmount, -1, 100, false, false);
                    teammate.playSound(teammate.getLocation(), "paladin.holyradiance.activation", 0.1f, 0.7f);
                    Location playerLoc = teammate.getLocation();
                    playerLoc.add(0.0, 2.1, 0.0);
                    Location particleLoc = playerLoc.clone();
                    for (int i = 0; i < 1; ++i) {
                        for (int j = 0; j < 10; ++j) {
                            double angle = (double)j / 10.0 * Math.PI * 2.0;
                            double width = 0.5;
                            particleLoc.setX(playerLoc.getX() + Math.sin(angle) * width);
                            particleLoc.setY(playerLoc.getY() + (double)i / 5.0);
                            particleLoc.setZ(playerLoc.getZ() + Math.cos(angle) * width);
                            ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(255, 255, 255), particleLoc, 500.0);
                        }
                    }
                }
            });
            if (++numberOfPlayersWithArmy < this.maxArmyAllies) continue;
            break;
        }
        return true;
    }

    public HashMap<WarlordsPlayer, Boolean> getPlayersPopped() {
        return this.playersPopped;
    }

    public boolean isArmyDead(WarlordsPlayer warlordsPlayer) {
        return this.playersPopped.get(warlordsPlayer);
    }

    public void pop(WarlordsPlayer warlordsPlayer) {
        this.playersPopped.put(warlordsPlayer, true);
    }

    public void setMaxArmyAllies(int maxArmyAllies) {
        this.maxArmyAllies = maxArmyAllies;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

