/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.game.state.EndState;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TimeWarp
extends AbstractAbility {
    protected int timesSuccessful = 0;
    private final int duration = 5;
    private int warpHealPercentage = 30;

    public TimeWarp() {
        super("Time Warp", 0.0f, 0.0f, 28.19f, 30, -1, 100);
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Times Successful", "" + this.timesSuccessful));
        return info;
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Activate to place a time rune on\n\u00a77the ground. After \u00a765 \u00a77seconds,\n\u00a77you will warp back to that location\n\u00a77and restore \u00a7a" + this.warpHealPercentage + "% \u00a77of your health";
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "mage.timewarp.activation", 3.0f, 1.0f);
        Location warpLocation = wp.getLocation();
        ArrayList warpTrail = new ArrayList();
        wp.getCooldownManager().addRegularCooldown(this.name, "TIME", TimeWarp.class, new TimeWarp(), wp, CooldownTypes.ABILITY, cooldownManager -> {
            if (wp.isDead() || wp.getGame().getState() instanceof EndState) {
                return;
            }
            ++this.timesSuccessful;
            Utils.playGlobalSound(wp.getLocation(), "mage.timewarp.teleport", 1.0f, 1.0f);
            wp.addHealingInstance(wp, this.name, (float)wp.getMaxHealth() * ((float)this.warpHealPercentage / 100.0f), (float)wp.getMaxHealth() * ((float)this.warpHealPercentage / 100.0f), -1, 100, false, false);
            wp.getEntity().teleport(warpLocation);
            warpTrail.clear();
        }, 100, (cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                for (Location location : warpTrail) {
                    ParticleEffect.SPELL_WITCH.display(0.01f, 0.0f, 0.01f, 0.001f, 1, location, 500.0);
                }
                warpTrail.add(wp.getLocation());
                ParticleEffect.SPELL_WITCH.display(0.1f, 0.0f, 0.1f, 0.001f, 4, warpLocation, 500.0);
                int points = 6;
                double radius = 0.5;
                for (int e = 0; e < points; ++e) {
                    double angle = Math.PI * 2 * (double)e / (double)points;
                    Location point = warpLocation.clone().add(radius * Math.sin(angle), 0.0, radius * Math.cos(angle));
                    ParticleEffect.CLOUD.display(0.1f, 0.0f, 0.1f, 0.001f, 1, point, 500.0);
                }
            }
        });
        return true;
    }

    public void setWarpHealPercentage(int warpHealPercentage) {
        this.warpHealPercentage = warpHealPercentage;
    }

    public int getTimesSuccessful() {
        return this.timesSuccessful;
    }
}

