/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.Soulbinding;
import com.ebicep.warlords.abilties.internal.AbstractChainBase;
import com.ebicep.warlords.events.WarlordsDamageHealingEvent;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.RegularCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpiritLink
extends AbstractChainBase {
    protected int numberOfDismounts = 0;
    private final int bounceRange = 10;

    public SpiritLink() {
        super("Spirit Link", 236.25f, 446.25f, 8.61f, 40, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Links your spirit with up to \u00a7c3 \u00a77enemy\n\u00a77players, dealing \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage\n\u00a77to the first target hit. Each additional hit\n\u00a77deals \u00a7c20% \u00a77reduced damage. You gain \u00a7e40%\n\u00a77speed for \u00a761.5 \u00a77seconds, and take \u00a7c15%\n\u00a77reduced damage for \u00a764.5 \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Hit", "" + this.playersHit));
        info.add(new Pair<String, String>("Dismounts", "" + this.numberOfDismounts));
        return info;
    }

    @Override
    protected int getHitCounterAndActivate(WarlordsPlayer wp, Player player) {
        int hitCounter = 0;
        for (WarlordsPlayer nearPlayer : PlayerFilter.entitiesAround((Entity)player, 20.0, 18.0, 20.0).aliveEnemiesOf(wp).lookingAtFirst(wp).soulBindedFirst(wp)) {
            if (!Utils.isLookingAtChain((LivingEntity)player, nearPlayer.getEntity()) || !Utils.hasLineOfSight((LivingEntity)player, nearPlayer.getEntity())) continue;
            ++this.playersHit;
            if (nearPlayer.onHorse()) {
                ++this.numberOfDismounts;
            }
            this.chain(player.getLocation(), nearPlayer.getLocation());
            nearPlayer.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            ++hitCounter;
            int numberOfHeals = wp.getCooldownManager().getNumberOfBoundPlayersLink(nearPlayer);
            for (int i = 0; i < numberOfHeals; ++i) {
                this.healNearPlayers(wp);
            }
            Iterator<WarlordsPlayer> iterator = PlayerFilter.entitiesAround(nearPlayer, 10.0, 10.0, 10.0).aliveEnemiesOf(wp).excluding(nearPlayer).soulBindedFirst(wp).iterator();
            if (!iterator.hasNext()) break;
            WarlordsPlayer chainPlayerOne = iterator.next();
            ++this.playersHit;
            if (chainPlayerOne.onHorse()) {
                ++this.numberOfDismounts;
            }
            this.chain(nearPlayer.getLocation(), chainPlayerOne.getLocation());
            chainPlayerOne.addDamageInstance(wp, this.name, this.minDamageHeal * 0.8f, this.maxDamageHeal * 0.8f, this.critChance, this.critMultiplier, false);
            ++hitCounter;
            numberOfHeals = wp.getCooldownManager().getNumberOfBoundPlayersLink(chainPlayerOne);
            for (int i = 0; i < numberOfHeals; ++i) {
                this.healNearPlayers(wp);
            }
            Iterator<WarlordsPlayer> iterator2 = PlayerFilter.entitiesAround(chainPlayerOne, 10.0, 10.0, 10.0).aliveEnemiesOf(wp).excluding(nearPlayer, chainPlayerOne).soulBindedFirst(wp).iterator();
            if (!iterator2.hasNext()) break;
            WarlordsPlayer chainPlayerTwo = iterator2.next();
            ++this.playersHit;
            if (chainPlayerTwo.onHorse()) {
                ++this.numberOfDismounts;
            }
            this.chain(chainPlayerOne.getLocation(), chainPlayerTwo.getLocation());
            chainPlayerTwo.addDamageInstance(wp, this.name, this.minDamageHeal * 0.6f, this.maxDamageHeal * 0.6f, this.critChance, this.critMultiplier, false);
            ++hitCounter;
            numberOfHeals = wp.getCooldownManager().getNumberOfBoundPlayersLink(chainPlayerTwo);
            for (int i = 0; i < numberOfHeals; ++i) {
                this.healNearPlayers(wp);
            }
        }
        return hitCounter;
    }

    @Override
    protected void onHit(WarlordsPlayer warlordsPlayer, Player player, int hitCounter) {
        player.playSound(player.getLocation(), "mage.firebreath.activation", 1.0f, 1.0f);
        warlordsPlayer.getSpeed().addSpeedModifier("Spirit Link", 40, 30, new String[0]);
        warlordsPlayer.getCooldownManager().addCooldown(new RegularCooldown<SpiritLink>(this.name, "LINK", SpiritLink.class, new SpiritLink(), warlordsPlayer, CooldownTypes.BUFF, cooldownManager -> {}, 90){

            @Override
            public float modifyDamageAfterInterveneFromSelf(WarlordsDamageHealingEvent event, float currentDamageValue) {
                float newDamageValue = currentDamageValue * 0.85f;
                event.getPlayer().addAbsorbed(Math.abs(currentDamageValue - newDamageValue));
                return newDamageValue;
            }
        });
        warlordsPlayer.getSpec().getRed().setCurrentCooldown((float)((double)this.cooldown * warlordsPlayer.getCooldownModifier()));
    }

    @Override
    protected ItemStack getChainItem() {
        return new ItemStack(Material.SPRUCE_FENCE_GATE);
    }

    private void healNearPlayers(WarlordsPlayer warlordsPlayer) {
        new CooldownFilter<RegularCooldown>(warlordsPlayer, RegularCooldown.class).filterName("Spirits Respite").findFirst().ifPresent(regularCooldown -> regularCooldown.setTicksLeft(Math.min(regularCooldown.getTicksLeft() + 10, 120)));
        warlordsPlayer.addHealingInstance(warlordsPlayer, "Soulbinding Weapon", 400.0f, 400.0f, -1, 100, false, false);
        for (WarlordsPlayer nearPlayer : PlayerFilter.entitiesAround(warlordsPlayer, 8.0, 8.0, 8.0).aliveTeammatesOfExcludingSelf(warlordsPlayer).limit(2L)) {
            warlordsPlayer.doOnStaticAbility(Soulbinding.class, Soulbinding::addLinkTeammatesHealed);
            nearPlayer.addHealingInstance(warlordsPlayer, "Soulbinding Weapon", 200.0f, 200.0f, -1, 100, false, false);
        }
    }
}

