/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownFilter;
import com.ebicep.warlords.player.cooldowns.CooldownManager;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.player.cooldowns.cooldowns.PersistentCooldown;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class Soulbinding
extends AbstractAbility {
    protected int playersBinded = 0;
    protected int soulProcs = 0;
    protected int linkProcs = 0;
    protected int soulTeammatesCDReductions = 0;
    protected int linkTeammatesHealed = 0;
    private final int duration = 12;
    private List<SoulBoundPlayer> soulBindedPlayers = new ArrayList<SoulBoundPlayer>();
    private int bindDuration = 2;
    private List<WarlordsPlayer> playersProcedBySouls = new ArrayList<WarlordsPlayer>();
    private List<WarlordsPlayer> playersProcedByLink = new ArrayList<WarlordsPlayer>();

    public Soulbinding() {
        super("Soulbinding Weapon", 0.0f, 0.0f, 21.92f, 30, -1, 100);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Your melee attacks \u00a7dBIND\n\u00a77enemies for \u00a76" + this.bindDuration + " \u00a77seconds.\n\u00a77Against \u00a7dBOUND \u00a77targets, your\n\u00a77next Spirit Link will heal you for\n\u00a7a400 \u00a77health (half for \u00a7e2 \u00a77nearby allies.)\n\u00a77Your next Fallen Souls will reduce the\n\u00a77cooldown of all abilities by \u00a761.5\n\u00a77seconds. (\u00a761 \u00a77second for \u00a7e2 \u00a77nearby\n\u00a77allies). Both buffs may be activated for\n\u00a77every melee hit. Lasts \u00a76" + 12 + " \u00a77seconds.\n\n\u00a77Successful soulbind procs will grant you\n\u00a77\u00a7625% \u00a77knockback resistance for \u00a761.2\n\u00a77seconds. (max \u00a763.6 \u00a77seconds)";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Binded", "" + this.playersBinded));
        info.add(new Pair<String, String>("Soul Procs", "" + this.soulProcs));
        info.add(new Pair<String, String>("Soul Teammates CD Reductions", "" + this.soulTeammatesCDReductions));
        info.add(new Pair<String, String>("Link Procs", "" + this.linkProcs));
        info.add(new Pair<String, String>("Link Teammates Healed", "" + this.linkTeammatesHealed));
        return info;
    }

    @Override
    public boolean onActivate(WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Utils.playGlobalSound(player.getLocation(), "paladin.consecrate.activation", 2.0f, 2.0f);
        Soulbinding tempSoulBinding = new Soulbinding();
        wp.getCooldownManager().addPersistentCooldown(this.name, "SOUL", Soulbinding.class, tempSoulBinding, wp, CooldownTypes.ABILITY, cooldownManager -> {
            if (new CooldownFilter<PersistentCooldown>((CooldownManager)cooldownManager, PersistentCooldown.class).filterCooldownClass(Soulbinding.class).stream().count() == 1L && wp.getEntity() instanceof Player) {
                ((Player)wp.getEntity()).getInventory().getItem(0).removeEnchantment(Enchantment.OXYGEN);
            }
        }, 240, soulbinding -> soulbinding.getSoulBindedPlayers().isEmpty(), (cooldown, ticksLeft, counter) -> {
            if (counter % 4 == 0) {
                Location location = wp.getLocation();
                location.add(0.0, 1.2, 0.0);
                ParticleEffect.SPELL_WITCH.display(0.2f, 0.0f, 0.2f, 0.1f, 2, location, 500.0);
            }
        });
        ItemMeta newItemMeta = player.getInventory().getItem(0).getItemMeta();
        newItemMeta.addEnchant(Enchantment.OXYGEN, 1, true);
        player.getInventory().getItem(0).setItemMeta(newItemMeta);
        return true;
    }

    public void addPlayersBinded() {
        ++this.playersBinded;
    }

    public void addSoulProcs() {
        ++this.soulProcs;
    }

    public void addLinkProcs() {
        ++this.linkProcs;
    }

    public void addSoulTeammatesCDReductions() {
        ++this.soulTeammatesCDReductions;
    }

    public void addLinkTeammatesHealed() {
        ++this.linkTeammatesHealed;
    }

    public List<SoulBoundPlayer> getSoulBindedPlayers() {
        return this.soulBindedPlayers;
    }

    public boolean hasBoundPlayer(WarlordsPlayer warlordsPlayer) {
        for (SoulBoundPlayer soulBindedPlayer : this.soulBindedPlayers) {
            if (soulBindedPlayer.getBoundPlayer() != warlordsPlayer) continue;
            return true;
        }
        return false;
    }

    public boolean hasBoundPlayerSoul(WarlordsPlayer warlordsPlayer) {
        for (SoulBoundPlayer soulBindedPlayer : this.soulBindedPlayers) {
            if (soulBindedPlayer.getBoundPlayer() != warlordsPlayer) continue;
            if (soulBindedPlayer.isHitWithSoul()) break;
            soulBindedPlayer.setHitWithSoul(true);
            this.playersProcedBySouls.add(warlordsPlayer);
            return true;
        }
        return false;
    }

    public boolean hasBoundPlayerLink(WarlordsPlayer warlordsPlayer) {
        for (SoulBoundPlayer soulBindedPlayer : this.soulBindedPlayers) {
            if (soulBindedPlayer.getBoundPlayer() != warlordsPlayer) continue;
            if (soulBindedPlayer.isHitWithLink()) break;
            soulBindedPlayer.setHitWithLink(true);
            this.playersProcedByLink.add(warlordsPlayer);
            return true;
        }
        return false;
    }

    public int getBindDuration() {
        return this.bindDuration;
    }

    public void setBindDuration(int bindDuration) {
        this.bindDuration = bindDuration;
    }

    public List<WarlordsPlayer> getAllProcedPlayers() {
        ArrayList<WarlordsPlayer> procedPlayers = new ArrayList<WarlordsPlayer>();
        procedPlayers.addAll(this.playersProcedBySouls);
        procedPlayers.addAll(this.playersProcedByLink);
        return procedPlayers;
    }

    public static class SoulBoundPlayer {
        private WarlordsPlayer boundPlayer;
        private float timeLeft;
        private boolean hitWithLink;
        private boolean hitWithSoul;

        public SoulBoundPlayer(WarlordsPlayer boundPlayer, int timeLeft) {
            this.boundPlayer = boundPlayer;
            this.timeLeft = timeLeft;
            this.hitWithLink = false;
            this.hitWithSoul = false;
        }

        public WarlordsPlayer getBoundPlayer() {
            return this.boundPlayer;
        }

        public void setBoundPlayer(WarlordsPlayer boundPlayer) {
            this.boundPlayer = boundPlayer;
        }

        public float getTimeLeft() {
            return this.timeLeft;
        }

        public void setTimeLeft(float timeLeft) {
            this.timeLeft = timeLeft;
        }

        public void decrementTimeLeft() {
            this.timeLeft = (float)((double)this.timeLeft - 0.5);
        }

        public boolean isHitWithLink() {
            return this.hitWithLink;
        }

        public void setHitWithLink(boolean hitWithLink) {
            this.hitWithLink = hitWithLink;
        }

        public boolean isHitWithSoul() {
            return this.hitWithSoul;
        }

        public void setHitWithSoul(boolean hitWithSoul) {
            this.hitWithSoul = hitWithSoul;
        }
    }
}

