/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.EffectUtils;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.player.cooldowns.CooldownTypes;
import com.ebicep.warlords.util.bukkit.PacketUtils;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SoulShackle
extends AbstractAbility {
    private final int shackleRange = 15;
    private float shacklePool = 0.0f;
    private final int maxShackleTargets = 1;
    private int minSilenceDurationInTicks = 40;
    private int maxSilenceDurationInTicks = 70;

    public SoulShackle() {
        super("Soul Shackle", 446.0f, 589.0f, 9.0f, 40, 20, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Shackle up to \u00a7e1 \u00a77enemy and deal \u00a7c" + this.format(this.minDamageHeal) + " \u00a77- \u00a7c" + this.format(this.maxDamageHeal) + " \u00a77damage.\n\u00a77Shackled enemies are silenced for \u00a76" + this.format((float)this.minSilenceDurationInTicks / 20.0f) + "\u00a77-\u00a76" + this.format((float)this.maxSilenceDurationInTicks / 20.0f) + " \u00a77seconds,\n\u00a77making them unable to use their main attack for\n\u00a77the duration. The silence duration increases by \u00a760.5\n\u00a77second for every \u00a7c500 \u00a77damage you took in the last\n\u00a766 \u00a77seconds. Gain a short burst of \u00a7e40% \u00a77movement speed\nfor \u00a761.5 \u00a77seconds after shackling an enemy.\n\n\u00a77Has an optimal range of \u00a7e" + 15 + " \u00a77blocks.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        return info;
    }

    @Override
    public boolean onActivate(@Nonnull WarlordsPlayer wp, @Nonnull Player player) {
        SoulShackle tempSoulShackle = new SoulShackle();
        Iterator<WarlordsPlayer> iterator = PlayerFilter.entitiesAround(wp, 15.0, 15.0, 15.0).aliveEnemiesOf(wp).requireLineOfSight(wp).closestFirst(wp).lookingAtFirst(wp).limit(1L).iterator();
        if (iterator.hasNext()) {
            WarlordsPlayer shackleTarget = iterator.next();
            wp.subtractEnergy(this.energyCost);
            Utils.playGlobalSound(player.getLocation(), "warrior.intervene.impact", 1.5f, 0.25f);
            Utils.playGlobalSound(player.getLocation(), "mage.fireball.activation", 1.5f, 0.2f);
            EffectUtils.playChainAnimation(wp, shackleTarget, new ItemStack(Material.PUMPKIN), 15);
            FireWorkEffectPlayer.playFirework(shackleTarget.getLocation(), FireworkEffect.builder().withColor(Color.YELLOW).with(FireworkEffect.Type.BALL).build());
            wp.getSpeed().addSpeedModifier("Shackle Speed", 40, 30, "BASE");
            wp.sendMessage(WarlordsPlayer.GIVE_ARROW_GREEN + ChatColor.GRAY + " You shackled " + ChatColor.YELLOW + shackleTarget.getName() + ChatColor.GRAY + "!");
            int silenceDuration = this.minSilenceDurationInTicks + (int)(this.shacklePool / 1000.0f) * 20;
            if (silenceDuration > this.maxSilenceDurationInTicks) {
                silenceDuration = this.maxSilenceDurationInTicks;
            }
            shackleTarget.addDamageInstance(wp, this.name, this.minDamageHeal, this.maxDamageHeal, this.critChance, this.critMultiplier, false);
            shackleTarget.getCooldownManager().removeCooldown(SoulShackle.class);
            if (!shackleTarget.getCooldownManager().hasCooldownFromName("Vindicate Debuff Immunity") && shackleTarget.getEntity() instanceof Player) {
                PacketUtils.sendTitle((Player)shackleTarget.getEntity(), "", "\u00a7cSILENCED", 0, silenceDuration, 0);
            }
            shackleTarget.getCooldownManager().addRegularCooldown("Shackle Silence", "SILENCE", SoulShackle.class, tempSoulShackle, wp, CooldownTypes.DEBUFF, cooldownManager -> {}, silenceDuration, (cooldown, ticksLeft, counter) -> {
                if (counter % 10 == 0) {
                    Utils.playGlobalSound(shackleTarget.getLocation(), Sound.DIG_SAND, 2.0f, 2.0f);
                    Location playerLoc = shackleTarget.getLocation();
                    Location particleLoc = playerLoc.clone();
                    for (int i = 0; i < 10; ++i) {
                        for (int j = 0; j < 10; ++j) {
                            double angle = (double)j / 10.0 * Math.PI * 2.0;
                            double width = 1.075;
                            particleLoc.setX(playerLoc.getX() + Math.sin(angle) * width);
                            particleLoc.setY(playerLoc.getY() + (double)i / 5.0);
                            particleLoc.setZ(playerLoc.getZ() + Math.cos(angle) * width);
                            ParticleEffect.REDSTONE.display((ParticleEffect.ParticleColor)new ParticleEffect.OrdinaryColor(25, 25, 25), particleLoc, 500.0);
                        }
                    }
                }
            });
            this.shacklePool = 0.0f;
            return true;
        }
        return false;
    }

    public float getShacklePool() {
        return this.shacklePool;
    }

    public void addToShacklePool(float amount) {
        this.shacklePool += amount;
    }

    @Override
    public void runEverySecond() {
        if (this.shacklePool > 0.0f) {
            float newPool = this.shacklePool - 200.0f;
            this.shacklePool = Math.max(newPool, 0.0f);
        }
    }

    public void setMaxSilenceDurationInTicks(int maxSilenceDurationInTicks) {
        this.maxSilenceDurationInTicks = maxSilenceDurationInTicks;
    }

    public void setMinSilenceDurationInTicks(int minSilenceDurationInTicks) {
        this.minSilenceDurationInTicks = minSilenceDurationInTicks;
    }
}

