/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlords.abilties;

import com.ebicep.warlords.Warlords;
import com.ebicep.warlords.abilties.internal.AbstractAbility;
import com.ebicep.warlords.effects.FireWorkEffectPlayer;
import com.ebicep.warlords.effects.ParticleEffect;
import com.ebicep.warlords.effects.circle.AreaEffect;
import com.ebicep.warlords.effects.circle.CircleEffect;
import com.ebicep.warlords.effects.circle.CircumferenceEffect;
import com.ebicep.warlords.player.WarlordsPlayer;
import com.ebicep.warlords.util.bukkit.Matrix4d;
import com.ebicep.warlords.util.java.Pair;
import com.ebicep.warlords.util.warlords.GameRunnable;
import com.ebicep.warlords.util.warlords.PlayerFilter;
import com.ebicep.warlords.util.warlords.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class SoothingElixir
extends AbstractAbility {
    protected int playersHealed = 0;
    private static final double SPEED = 0.22;
    private static final double GRAVITY = -0.008;
    private static final float HITBOX = 5.0f;
    private final int puddleMinDamage = 235;
    private final int puddleMaxDamage = 342;
    private final int puddleMinHealing = 158;
    private final int puddleMaxHealing = 204;

    public SoothingElixir() {
        super("Soothing Elixir", 551.0f, 648.0f, 7.0f, 60, 25, 175);
    }

    @Override
    public void updateDescription(Player player) {
        this.description = "\u00a77Throw a short range elixir bottle, The bottle\n\u00a77will shatter upon impact, healing nearby allies\n\u00a77for \u00a7a" + this.format(this.minDamageHeal) + " \u00a77- \u00a7a" + this.format(this.maxDamageHeal) + " \u00a77health and damage nearby\n\u00a77enemies for \u00a7c" + 235 + " \u00a77- \u00a7c" + 342 + " \u00a77damage. The projectile\n\u00a77will form a small puddle that heals allies for\n\u00a7a" + 158 + " \u00a77- \u00a7a" + 204 + " \u00a77health per second. Lasts \u00a764 \u00a77seconds.";
    }

    @Override
    public List<Pair<String, String>> getAbilityInfo() {
        ArrayList<Pair<String, String>> info = new ArrayList<Pair<String, String>>();
        info.add(new Pair<String, String>("Times Used", "" + this.timesUsed));
        info.add(new Pair<String, String>("Players Healed", "" + this.playersHealed));
        return info;
    }

    @Override
    public boolean onActivate(final WarlordsPlayer wp, Player player) {
        wp.subtractEnergy(this.energyCost);
        Location location = player.getLocation();
        final Vector speed = player.getLocation().getDirection().multiply(0.22);
        final ArmorStand stand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        stand.setHelmet(new ItemStack(Material.STAINED_GLASS, 1, 6));
        stand.setGravity(false);
        stand.setVisible(false);
        new GameRunnable(wp.getGame()){
            int timer;
            {
                super(game);
                this.timer = 0;
            }

            @Override
            public void run() {
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(false);
                this.quarterStep(true);
            }

            private void quarterStep(boolean last) {
                boolean shouldExplode;
                if (!stand.isValid()) {
                    this.cancel();
                    return;
                }
                speed.add(new Vector(0.0, -0.00176, 0.0));
                final Location newLoc = stand.getLocation();
                newLoc.add(speed);
                stand.teleport(newLoc);
                newLoc.add(0.0, 1.75, 0.0);
                stand.setHeadPose(new EulerAngle(-speed.getY() * 3.0, 0.0, 0.0));
                ++this.timer;
                if (last) {
                    Matrix4d center = new Matrix4d(newLoc);
                    for (float i = 0.0f; i < 6.0f; i += 1.0f) {
                        double angle = Math.toRadians(i * 90.0f) + (double)this.timer * 0.3;
                        double width = 0.3;
                        ParticleEffect.VILLAGER_HAPPY.display(0.0f, 0.0f, 0.0f, 0.0f, 2, center.translateVector(newLoc.getWorld(), 0.0, Math.sin(angle) * width, Math.cos(angle) * width), 500.0);
                    }
                }
                if (!newLoc.getBlock().isEmpty() && newLoc.getBlock().getType() != Material.GRASS && newLoc.getBlock().getType() != Material.BARRIER && newLoc.getBlock().getType() != Material.VINE) {
                    shouldExplode = true;
                } else {
                    WarlordsPlayer directHit = PlayerFilter.entitiesAroundRectangle(newLoc, 1.0, 2.0, 1.0).aliveTeammatesOfExcludingSelf(wp).findFirstOrNull();
                    boolean bl = shouldExplode = directHit != null;
                }
                if (shouldExplode) {
                    stand.remove();
                    Utils.playGlobalSound(newLoc, "rogue.healingremedy.impact", 1.5f, 0.1f);
                    Utils.playGlobalSound(newLoc, Sound.GLASS, 1.5f, 0.7f);
                    Utils.playGlobalSound(newLoc, "mage.waterbolt.impact", 1.5f, 0.3f);
                    CircleEffect circleEffect = new CircleEffect(wp.getGame(), wp.getTeam(), newLoc, 5.0, new CircumferenceEffect(ParticleEffect.VILLAGER_HAPPY, ParticleEffect.REDSTONE), new AreaEffect(1.0, ParticleEffect.DRIP_WATER).particlesPerSurface(0.025));
                    final BukkitTask particleTask = Bukkit.getScheduler().runTaskTimer((Plugin)Warlords.getInstance(), circleEffect::playEffects, 0L, 1L);
                    wp.getGame().registerGameTask(particleTask);
                    FireWorkEffectPlayer.playFirework(newLoc, FireworkEffect.builder().withColor(Color.WHITE).with(FireworkEffect.Type.BURST).build());
                    for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(newLoc, 5.0, 5.0, 5.0).aliveTeammatesOf(wp)) {
                        nearEntity.addHealingInstance(wp, SoothingElixir.this.name, SoothingElixir.this.minDamageHeal, SoothingElixir.this.maxDamageHeal, SoothingElixir.this.critChance, SoothingElixir.this.critMultiplier, false, false);
                    }
                    new GameRunnable(wp.getGame()){
                        int timeLeft;
                        {
                            super(game);
                            this.timeLeft = 4;
                        }

                        @Override
                        public void run() {
                            PlayerFilter.entitiesAround(newLoc, 5.0, 5.0, 5.0).aliveTeammatesOf(wp).forEach((Consumer<? super WarlordsPlayer>)((Consumer<WarlordsPlayer>)ally -> ally.addHealingInstance(wp, SoothingElixir.this.name, 158.0f, 204.0f, SoothingElixir.this.critChance, SoothingElixir.this.critMultiplier, false, false)));
                            --this.timeLeft;
                            if (this.timeLeft <= 0) {
                                this.cancel();
                                particleTask.cancel();
                            }
                        }
                    }.runTaskTimer(20L, 20L);
                    for (WarlordsPlayer nearEntity : PlayerFilter.entitiesAround(newLoc, 5.0, 5.0, 5.0).aliveEnemiesOf(wp)) {
                        Utils.playGlobalSound(nearEntity.getLocation(), Sound.GLASS, 1.0f, 0.5f);
                        nearEntity.addDamageInstance(wp, SoothingElixir.this.name, 235.0f, 342.0f, SoothingElixir.this.critChance, SoothingElixir.this.critMultiplier, false);
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer(0L, 1L);
        Utils.playGlobalSound(player.getLocation(), "mage.frostbolt.activation", 2.0f, 0.7f);
        return true;
    }
}

